/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.connection;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.soap.internal.loader.property.SoapExtensionModelProperty;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.SoapConnectionProviderObjectBuilder;

public class ConnectionProviderObjectFactory
extends AbstractExtensionObjectFactory<ConnectionProviderResolver> {
    private final ConnectionProviderModel providerModel;
    private final ExtensionModel extensionModel;
    private final ExtensionsOAuthManager oauthManager;
    private PoolingProfile poolingProfile = null;
    private RetryPolicyTemplate retryPolicyTemplate = null;
    private boolean disableValidation = false;
    @Inject
    private MuleContext muleContext;

    public ConnectionProviderObjectFactory(ConnectionProviderModel providerModel, ExtensionModel extensionModel, ExtensionsOAuthManager oauthManager, MuleContext muleContext) {
        super(muleContext);
        this.providerModel = providerModel;
        this.extensionModel = extensionModel;
        this.oauthManager = oauthManager;
    }

    public ConnectionProviderResolver doGetObject() throws Exception {
        Callable<ResolverSet> callable = () -> this.parametersResolver.getParametersAsHashedResolverSet((ParameterizedModel)this.providerModel, this.muleContext);
        ResolverSet resolverSet = (ResolverSet)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader((ExtensionModel)this.extensionModel), callable);
        ConnectionManagerAdapter connectionManager = this.getConnectionManager();
        Object builder = this.extensionModel.getModelProperty(SoapExtensionModelProperty.class).isPresent() ? new SoapConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.disableValidation, this.retryPolicyTemplate, connectionManager, this.extensionModel, this.muleContext) : (this.providerModel.getModelProperty(OAuthModelProperty.class).isPresent() ? new OAuthConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.disableValidation, this.retryPolicyTemplate, this.oauthManager, connectionManager, this.extensionModel, this.muleContext) : new DefaultConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.disableValidation, this.retryPolicyTemplate, connectionManager, this.extensionModel, this.muleContext));
        return new ConnectionProviderResolver((ConnectionProviderObjectBuilder)builder, resolverSet, this.muleContext);
    }

    private ConnectionManagerAdapter getConnectionManager() throws ConfigurationException {
        try {
            return (ConnectionManagerAdapter)this.muleContext.getRegistry().lookupObject(ConnectionManagerAdapter.class);
        }
        catch (RegistrationException e) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Could not obtain connection manager adapter form registry"), (Throwable)e);
        }
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public void setDisableValidation(boolean disableValidation) {
        this.disableValidation = disableValidation;
    }
}

