/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.source;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ExtensionSourceObjectFactory
extends AbstractExtensionObjectFactory<ExtensionMessageSource> {
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private ConfigurationProvider configurationProvider;
    private RetryPolicyTemplate retryPolicyTemplate;
    private CursorProviderFactory cursorProviderFactory;
    @Inject
    private ConnectionManagerAdapter connectionManager;

    public ExtensionSourceObjectFactory(ExtensionModel extensionModel, SourceModel sourceModel, MuleContext muleContext) {
        super(muleContext);
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
    }

    @Override
    protected ParametersResolver getParametersResolver(MuleContext muleContext) {
        return ParametersResolver.fromValues((Map)this.parameters, (MuleContext)muleContext);
    }

    public ExtensionMessageSource doGetObject() throws ConfigurationException, InitialisationException {
        return (ExtensionMessageSource)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader((ExtensionModel)this.extensionModel), () -> {
            this.parametersResolver.checkParameterGroupExclusiveness((ParameterizedModel)this.sourceModel, this.parameters.keySet());
            ResolverSet nonCallbackParameters = this.getNonCallbackParameters();
            if (nonCallbackParameters.isDynamic()) {
                throw this.dynamicParameterException(nonCallbackParameters, this.sourceModel);
            }
            ResolverSet responseCallbackParameters = this.getCallbackParameters(this.sourceModel.getSuccessCallback());
            ResolverSet errorCallbackParameters = this.getCallbackParameters(this.sourceModel.getErrorCallback());
            LifecycleUtils.initialiseIfNeeded((Object)nonCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)responseCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)errorCallbackParameters, (boolean)true, (MuleContext)this.muleContext);
            return new ExtensionMessageSource(this.extensionModel, this.sourceModel, this.getSourceAdapterFactory(nonCallbackParameters, responseCallbackParameters, errorCallbackParameters), this.configurationProvider, this.getRetryPolicyTemplate(), this.cursorProviderFactory, this.muleContext.getExtensionManager());
        });
    }

    private ResolverSet getNonCallbackParameters() throws ConfigurationException {
        return this.parametersResolver.getParametersAsResolverSet(this.muleContext, (ParameterizedModel)this.sourceModel, this.sourceModel.getParameterGroupModels());
    }

    private ResolverSet getCallbackParameters(Optional<SourceCallbackModel> callbackModel) throws ConfigurationException {
        if (callbackModel.isPresent()) {
            return this.parametersResolver.getParametersAsResolverSet((ParameterizedModel)callbackModel.get(), this.muleContext);
        }
        return new ResolverSet(this.muleContext);
    }

    private SourceAdapterFactory getSourceAdapterFactory(ResolverSet nonCallbackParameters, ResolverSet successCallbackParameters, ResolverSet errorCallbackParameters) {
        return new SourceAdapterFactory(this.extensionModel, this.sourceModel, nonCallbackParameters, successCallbackParameters, errorCallbackParameters, this.cursorProviderFactory, this.muleContext);
    }

    private RetryPolicyTemplate getRetryPolicyTemplate() throws ConfigurationException {
        return this.retryPolicyTemplate != null ? this.retryPolicyTemplate : ReconnectionConfig.getDefault().getRetryPolicyTemplate();
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    private ConfigurationException dynamicParameterException(ResolverSet resolverSet, SourceModel model) {
        List dynamicParams = resolverSet.getResolvers().entrySet().stream().filter(entry -> ((ValueResolver)entry.getValue()).isDynamic()).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        return new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("The '%s' message source is using expressions, which are not allowed on message sources. Offending parameters are: [%s]", model.getName(), Joiner.on((char)',').join(dynamicParams))));
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public void setCursorProviderFactory(CursorProviderFactory cursorProviderFactory) {
        this.cursorProviderFactory = cursorProviderFactory;
    }
}

