/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.metadata;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.extension.api.soap.WebServiceDefinition;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.api.metadata.MultilevelMetadataKeyBuilder;
import org.mule.runtime.module.extension.soap.internal.metadata.BaseInvokeResolver;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;
import org.mule.runtime.soap.api.client.metadata.SoapMetadataResolver;

public final class InvokeKeysResolver
extends BaseInvokeResolver
implements TypeKeysResolver {
    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        ForwardingSoapClient connection = this.getConnection(context);
        ImmutableSet.Builder keys = ImmutableSet.builder();
        connection.getAllWebServices().forEach(ws -> keys.add((Object)this.buildServiceKey(connection, (WebServiceDefinition)ws)));
        return keys.build();
    }

    private MetadataKey buildServiceKey(ForwardingSoapClient connection, WebServiceDefinition ws) {
        String serviceId = ws.getServiceId();
        SoapMetadataResolver resolver = connection.getSoapClient(serviceId).getMetadataResolver();
        MetadataKeyBuilder key = MultilevelMetadataKeyBuilder.newKey((String)serviceId).withDisplayName(ws.getFriendlyName());
        List excludedOperations = ws.getExcludedOperations();
        resolver.getAvailableOperations().stream().filter(ope -> !excludedOperations.contains(ope)).forEach(ope -> key.withChild(MultilevelMetadataKeyBuilder.newKey((String)ope).withDisplayName(NameUtils.titleize((String)ope))));
        return key.build();
    }
}

