/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader.type.runtime;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.annotation.Soap;
import org.mule.runtime.extension.api.soap.annotation.SoapMessageDispatcherProviders;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.MessageDispatcherProviderTypeWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapComponentWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapServiceProviderWrapper;

public class SoapExtensionTypeWrapper<T>
extends SoapComponentWrapper {
    public SoapExtensionTypeWrapper(Class<T> extensionType) {
        super(extensionType);
    }

    public List<SoapServiceProviderWrapper> getSoapServiceProviders() {
        ImmutableList.Builder serviceProviders = ImmutableList.builder();
        if (SoapServiceProvider.class.isAssignableFrom(this.getDeclaringClass())) {
            serviceProviders.add((Object)new SoapServiceProviderWrapper(this.getDeclaringClass()));
        }
        this.getAnnotation(Soap.class).ifPresent(soap -> Arrays.stream(soap.value()).forEach(sp -> serviceProviders.add((Object)new SoapServiceProviderWrapper((Class<? extends SoapServiceProvider>)sp))));
        return serviceProviders.build();
    }

    public List<MessageDispatcherProviderTypeWrapper> getDispatcherProviders() {
        ImmutableList.Builder transportProviders = ImmutableList.builder();
        Optional customTransport = this.getAnnotation(SoapMessageDispatcherProviders.class);
        customTransport.ifPresent(ct -> transportProviders.addAll((Iterable)Arrays.stream(ct.value()).map(MessageDispatcherProviderTypeWrapper::new).collect(Collectors.toList())));
        return transportProviders.build();
    }
}

