/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.execution;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.mule.runtime.module.extension.internal.runtime.operation.construct.Operation;

public class MuleOperationExecutor
implements CompletableComponentExecutor<ComponentModel>,
Initialisable {
    private static final Message NULL_MESSAGE = Message.builder().nullValue().build();
    private final ComponentModel operationModel;
    private Operation operation;
    @Inject
    private MuleContext muleContext;

    public MuleOperationExecutor(ComponentModel operationModel) {
        this.operationModel = operationModel;
    }

    public void initialise() throws InitialisationException {
        this.operation = (Operation)new DefaultRegistry(this.muleContext).lookupByName(this.operationModel.getName()).orElseThrow(() -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("Operation '%s' not found in registry", this.operationModel.getName())), (Initialisable)this));
    }

    public void execute(ExecutionContext<ComponentModel> executionContext, CompletableComponentExecutor.ExecutorCallback callback) {
        ExecutionContextAdapter ctx = (ExecutionContextAdapter)executionContext;
        CoreEvent inputEvent = ctx.getEvent();
        CoreEvent executionEvent = CoreEvent.builder((EventContext)inputEvent.getContext()).parameters(this.buildOperationParameters(inputEvent, (ExecutionContextAdapter<ComponentModel>)ctx)).message(NULL_MESSAGE).build();
        this.operation.execute((Event)executionEvent).whenComplete((resultEvent, exception) -> {
            if (exception != null) {
                callback.error(MuleOperationExecutor.tryCreateTypedExceptionFrom(exception));
            } else {
                callback.complete((Object)CoreEvent.builder((CoreEvent)inputEvent).message(resultEvent.getMessage()).build());
            }
        });
    }

    private Map<String, ?> buildOperationParameters(CoreEvent inputEvent, ExecutionContextAdapter<ComponentModel> ctx) {
        HashMap parameters = new HashMap();
        SdkInternalContext.from((CoreEvent)inputEvent).getOperationExecutionParams(ctx.getComponent().getLocation(), inputEvent.getContext().getId()).parameters().forEach((key, value) -> parameters.put(key, this.mapParameterValue(value)));
        return parameters;
    }

    private Object mapParameterValue(Object parameterValue) {
        return parameterValue instanceof ConfigurationProvider ? ((ConfigurationProvider)parameterValue).getName() : parameterValue;
    }

    private static Throwable tryCreateTypedExceptionFrom(Throwable exception) {
        return MuleOperationExecutor.getErrorType(exception).map(errorType -> MuleOperationExecutor.wrapInTyped(exception, errorType)).orElse(exception);
    }

    private static Optional<ErrorType> getErrorType(Throwable exception) {
        List exceptionsAsList = ExceptionHelper.getExceptionsAsList((Throwable)exception);
        for (Throwable e : exceptionsAsList) {
            Optional optionalError;
            if (!(e instanceof ComponentExecutionException) || !(optionalError = ((ComponentExecutionException)e).getEvent().getError()).isPresent()) continue;
            return optionalError.map(Error::getErrorType);
        }
        return Optional.empty();
    }

    private static Throwable wrapInTyped(Throwable throwable, ErrorType errorType) {
        if (throwable instanceof TypedException) {
            return throwable;
        }
        return new TypedException(throwable, errorType);
    }
}

