/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.module.extension.mule.internal.loader.parser.BaseMuleSdkExtensionModelParser;

public class ParameterLayoutParser
extends BaseMuleSdkExtensionModelParser {
    private static final String PARAMETER_LAYOUT_DSL_KEY = "parameter-metadata";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EXAMPLE = "example";
    private static final String SUMMARY = "summary";
    private static final String TEXT = "text";
    private static final String SECRET_TYPE = "secret";
    private static final String PATH = "path";
    private static final String TYPE = "type";
    private static final String ACCEPTS_URLS = "acceptsUrls";
    private static final String LOCATION = "location";
    private static final String ACCEPTED_FILE_EXTENSIONS = "acceptedFileExtensions";
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final String ORDER = "order";
    private static final Map<String, String> SECRET_TYPE_TO_SEMANTIC_TERM = new HashMap<String, String>(11);
    private final ComponentAst parameterAst;
    private LayoutModel layoutModel = null;
    private DisplayModel displayModel = null;
    private final Set<String> semanticTerms = new HashSet<String>(1);

    public ParameterLayoutParser(ComponentAst parameterAst) {
        this.parameterAst = parameterAst;
        this.parseStructure();
    }

    private void parseStructure() {
        this.getSingleChild(this.parameterAst, PARAMETER_LAYOUT_DSL_KEY).ifPresent(this::parseParameterMetadata);
    }

    private void parseParameterMetadata(ComponentAst metadataAst) {
        DisplayModel.DisplayModelBuilder displayModelBuilder = DisplayModel.builder();
        LayoutModel.LayoutModelBuilder layoutModelBuilder = LayoutModel.builder();
        boolean wasSomeDisplayModelParamSet = this.setDisplayNameIfNeeded(metadataAst, displayModelBuilder);
        wasSomeDisplayModelParamSet |= this.setExampleIfNeeded(metadataAst, displayModelBuilder);
        wasSomeDisplayModelParamSet |= this.setSummaryIfNeeded(metadataAst, displayModelBuilder);
        boolean wasSomeLayoutModelParamSet = this.setTextIfNeeded(metadataAst, layoutModelBuilder);
        wasSomeLayoutModelParamSet |= this.setSecretIfNeeded(metadataAst, layoutModelBuilder);
        wasSomeLayoutModelParamSet |= this.setOrderIfNeeded(metadataAst, layoutModelBuilder);
        if (wasSomeDisplayModelParamSet |= this.setPathIfNeeded(metadataAst, displayModelBuilder)) {
            this.displayModel = displayModelBuilder.build();
        }
        if (wasSomeLayoutModelParamSet) {
            this.layoutModel = layoutModelBuilder.build();
        }
    }

    private boolean setTextIfNeeded(ComponentAst metadataAst, LayoutModel.LayoutModelBuilder layoutModelBuilder) {
        Optional isText = this.getOptionalParameter(metadataAst, TEXT);
        if (isText.isPresent()) {
            if (((Boolean)isText.get()).booleanValue()) {
                layoutModelBuilder.asText();
            }
            return true;
        }
        return false;
    }

    private boolean setSecretIfNeeded(ComponentAst metadataAst, LayoutModel.LayoutModelBuilder layoutModelBuilder) {
        Optional secret = this.getOptionalParameter(metadataAst, SECRET_TYPE);
        if (secret.isPresent()) {
            this.semanticTerms.add(this.toSemanticTerm((String)secret.get()));
            layoutModelBuilder.asPassword();
            return true;
        }
        return false;
    }

    private String toSemanticTerm(String secretType) {
        return SECRET_TYPE_TO_SEMANTIC_TERM.getOrDefault(secretType, "connectivity.secret");
    }

    private boolean setOrderIfNeeded(ComponentAst metadataAst, LayoutModel.LayoutModelBuilder layoutModelBuilder) {
        Optional order = this.getOptionalParameter(metadataAst, ORDER);
        if (order.isPresent()) {
            layoutModelBuilder.order(((Integer)order.get()).intValue());
            return true;
        }
        return false;
    }

    private boolean setDisplayNameIfNeeded(ComponentAst metadataAst, DisplayModel.DisplayModelBuilder displayModelBuilder) {
        Optional displayName = this.getOptionalParameter(metadataAst, DISPLAY_NAME);
        if (displayName.isPresent() && !StringUtils.isBlank((String)((String)displayName.get()))) {
            displayModelBuilder.displayName((String)displayName.get());
            return true;
        }
        return false;
    }

    private boolean setExampleIfNeeded(ComponentAst metadataAst, DisplayModel.DisplayModelBuilder displayModelBuilder) {
        Optional example = this.getOptionalParameter(metadataAst, EXAMPLE);
        if (example.isPresent() && !StringUtils.isBlank((String)((String)example.get()))) {
            displayModelBuilder.example((String)example.get());
            return true;
        }
        return false;
    }

    private boolean setSummaryIfNeeded(ComponentAst metadataAst, DisplayModel.DisplayModelBuilder displayModelBuilder) {
        Optional summary = this.getOptionalParameter(metadataAst, SUMMARY);
        if (summary.isPresent() && !StringUtils.isBlank((String)((String)summary.get()))) {
            displayModelBuilder.summary((String)summary.get());
            return true;
        }
        return false;
    }

    private boolean setPathIfNeeded(ComponentAst metadataAst, DisplayModel.DisplayModelBuilder displayModelBuilder) {
        Optional<PathModel> pathModel = this.getSingleChild(metadataAst, PATH).map(this::parsePathModel);
        if (pathModel.isPresent()) {
            displayModelBuilder.path(pathModel.get());
            return true;
        }
        return false;
    }

    private PathModel parsePathModel(ComponentAst pathAst) {
        PathModel.Type type = this.getOptionalParameter(pathAst, TYPE).map(asString -> Enum.valueOf(PathModel.Type.class, (String)asString)).orElse(PathModel.Type.ANY);
        Boolean acceptsUrls = this.getOptionalParameter(pathAst, ACCEPTS_URLS).map(Boolean.class::cast).orElse(false);
        PathModel.Location location = this.getOptionalParameter(pathAst, LOCATION).map(asString -> Enum.valueOf(PathModel.Location.class, (String)asString)).orElse(PathModel.Location.ANY);
        String[] acceptedFileExtensions = this.getOptionalParameter(pathAst, ACCEPTED_FILE_EXTENSIONS).map(asString -> ((String)asString).split(",")).orElse(EMPTY_ARRAY);
        return new PathModel(type, acceptsUrls.booleanValue(), location, acceptedFileExtensions);
    }

    public Optional<LayoutModel> getLayoutModel() {
        return Optional.ofNullable(this.layoutModel);
    }

    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public Set<String> getSemanticTerms() {
        return this.semanticTerms;
    }

    static {
        SECRET_TYPE_TO_SEMANTIC_TERM.put("CLIENT_ID", "connectivity.clientId");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("CLIENT_SECRET", "connectivity.clientSecret");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("TOKEN_ID", "connectivity.tokenId");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("PASSWORD", "connectivity.password");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("TOKEN_URL_TEMPLATE", "core.tokenUrlTemplate");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("TOKEN_SECRET", "connectivity.secretToken");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("API_KEY", "connectivity.apiKey");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("SECRET_TOKEN", "connectivity.secretToken");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("SECURITY_TOKEN", "connectivity.securityToken");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("RSA_PRIVATE_KEY", "connectivity.secret");
        SECRET_TYPE_TO_SEMANTIC_TERM.put("SECRET", "connectivity.secret");
    }
}

