/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ComponentAst;

public class Characteristic<T> {
    private static final String CHARACTERISTICS_NOT_COMPUTED_MSG = "Characteristics have not been computed yet.";
    private final BiFunction<OperationModel, T, T> mapper;
    private final T defaultValue;
    private final T stopValue;
    private T value;

    private Characteristic(BiFunction<OperationModel, T, T> mapper, T defaultValue, T stopValue) {
        this.mapper = mapper;
        this.defaultValue = defaultValue;
        this.stopValue = stopValue;
    }

    public void computeFrom(OperationModel operationModel) {
        this.value = this.mapper.apply(operationModel, (OperationModel)this.value);
    }

    public void setWithDefault() {
        this.value = this.defaultValue;
    }

    public boolean hasDefinitiveValue() {
        if (this.stopValue == null) {
            return false;
        }
        return this.stopValue.equals(this.value);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public T getValue() {
        Preconditions.checkState((boolean)this.hasValue(), (String)CHARACTERISTICS_NOT_COMPUTED_MSG);
        return this.value;
    }

    public static class AnyMatchFilteringCharacteristic
    extends BooleanFilteringCharacteristic {
        public AnyMatchFilteringCharacteristic(Predicate<OperationModel> predicate, Predicate<ComponentAst> filterExpression, Predicate<ComponentAst> ignoreExpression) {
            super(predicate, false, true, filterExpression, ignoreExpression);
        }
    }

    public static class BooleanFilteringCharacteristic
    extends FilteringCharacteristic<Boolean> {
        private BooleanFilteringCharacteristic(Predicate<OperationModel> predicate, Boolean defaultValue, Boolean stopValue, Predicate<ComponentAst> filter, Predicate<ComponentAst> ignore) {
            super((T operationModel, U curValue) -> curValue != null && curValue == stopValue ? curValue.booleanValue() : predicate.test((OperationModel)operationModel), defaultValue, stopValue, filter, ignore);
        }
    }

    public static class FilteringCharacteristic<T>
    extends Characteristic<T> {
        private final Predicate<ComponentAst> filterExpression;
        private final Predicate<ComponentAst> ignoreExpression;

        private FilteringCharacteristic(BiFunction<OperationModel, T, T> mapper, T defaultValue, T stopValue, Predicate<ComponentAst> filter, Predicate<ComponentAst> ignore) {
            super(mapper, defaultValue, stopValue);
            this.filterExpression = filter;
            this.ignoreExpression = ignore;
        }

        public boolean filterComponent(ComponentAst componentAst) {
            return this.filterExpression.test(componentAst);
        }

        public boolean ignoreComponent(ComponentAst componentAst) {
            return this.ignoreExpression.test(componentAst);
        }
    }

    public static class AggregatedNotificationsCharacteristic
    extends Characteristic<List<NotificationModel>> {
        public AggregatedNotificationsCharacteristic() {
            super(AggregatedNotificationsCharacteristic::aggregator, Collections.emptyList(), null);
        }

        private static List<NotificationModel> aggregator(OperationModel operationModel, List<NotificationModel> notificationModels) {
            if (notificationModels == null) {
                notificationModels = new ArrayList<NotificationModel>();
            }
            notificationModels.addAll(operationModel.getNotificationModels());
            return notificationModels;
        }
    }

    public static class AnyMatchCharacteristic
    extends BooleanCharacteristic {
        public AnyMatchCharacteristic(Predicate<OperationModel> predicate) {
            super(predicate, false, true);
        }
    }

    public static class BooleanCharacteristic
    extends Characteristic<Boolean> {
        private BooleanCharacteristic(Predicate<OperationModel> predicate, Boolean defaultValue, Boolean stopValue) {
            super((T operationModel, U curValue) -> curValue != null && curValue == stopValue ? curValue.booleanValue() : predicate.test((OperationModel)operationModel), defaultValue, stopValue);
        }
    }
}

