/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.parser;

import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.extension.api.loader.ExtensionDevelopmentFramework;
import org.mule.runtime.extension.api.loader.parser.ConfigurationModelParser;
import org.mule.runtime.extension.api.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.ErrorModelParser;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParser;
import org.mule.runtime.extension.api.loader.parser.FunctionModelParser;
import org.mule.runtime.extension.api.loader.parser.LicenseModelParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.OperationModelParser;
import org.mule.runtime.extension.api.loader.parser.SourceModelParser;
import org.mule.runtime.extension.api.loader.parser.XmlDslConfiguration;
import org.mule.runtime.extension.api.runtime.exception.SdkExceptionHandlerFactory;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityConfigurationModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityLicenseModelParser;
import org.mule.sdk.api.artifact.lifecycle.ArtifactLifecycleListener;

public class ConnectivityExtensionModelParser
implements ExtensionModelParser {
    private final MuleConnectorSerializableModel muleConnectorSerializableModel;
    private final String extensionName;

    public ConnectivityExtensionModelParser(MuleConnectorSerializableModel muleConnectorSerializableModel) {
        this.muleConnectorSerializableModel = muleConnectorSerializableModel;
        this.extensionName = this.muleConnectorSerializableModel.getName().toLowerCase();
    }

    public String getName() {
        return this.extensionName;
    }

    public Category getCategory() {
        return this.muleConnectorSerializableModel.getCategory();
    }

    public String getVendor() {
        return this.muleConnectorSerializableModel.getVendor();
    }

    public List<ConfigurationModelParser> getConfigurationParsers() {
        return Collections.singletonList(new ConnectivityConfigurationModelParser(this.muleConnectorSerializableModel));
    }

    public List<OperationModelParser> getOperationModelParsers() {
        return List.of();
    }

    public List<SourceModelParser> getSourceModelParsers() {
        return List.of();
    }

    public List<ConnectionProviderModelParser> getConnectionProviderModelParsers() {
        return List.of();
    }

    public List<FunctionModelParser> getFunctionModelParsers() {
        return List.of();
    }

    public List<ErrorModelParser> getErrorModelParsers() {
        return List.of();
    }

    public LicenseModelParser getLicensingParser() {
        return new ConnectivityLicenseModelParser(true, true);
    }

    public List<ExternalLibraryModel> getExternalLibraryModels() {
        return List.of();
    }

    public Optional<SdkExceptionHandlerFactory> getExceptionHandlerFactory() {
        return Optional.empty();
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    public Optional<XmlDslConfiguration> getXmlDslConfiguration() {
        return Optional.of(new XmlDslConfiguration(this.extensionName, "http://www.mulesoft.org/schema/connectivity/" + this.extensionName));
    }

    public List<MetadataType> getExportedTypes() {
        return List.of();
    }

    public List<String> getExportedResources() {
        return List.of();
    }

    public List<MetadataType> getImportedTypes() {
        return List.of();
    }

    public List<String> getPrivilegedExportedArtifacts() {
        return List.of();
    }

    public List<String> getPrivilegedExportedPackages() {
        return List.of();
    }

    public Map<MetadataType, List<MetadataType>> getSubTypes() {
        return Map.of();
    }

    public List<NotificationModel> getNotificationModels() {
        return List.of();
    }

    public String getNamespace() {
        return "http://www.mulesoft.org/schema/connectivity/" + this.extensionName;
    }

    public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
        return Optional.empty();
    }

    public ExtensionDevelopmentFramework getDevelopmentFramework() {
        return ExtensionDevelopmentFramework.IC_SDK;
    }

    public Optional<Class<? extends ArtifactLifecycleListener>> getArtifactLifecycleListenerClass() {
        return Optional.empty();
    }

    public Set<String> getSupportedJavaVersions() {
        return Set.of("17", "21");
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return List.of();
    }
}

