/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.dsl.internal.component.config.InternalComponentConfiguration;

@Deprecated
public abstract class ComponentConfiguration {
    protected ComponentIdentifier identifier;
    protected ComponentLocation componentLocation;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected List<ComponentConfiguration> nestedComponents = new ArrayList<ComponentConfiguration>();
    protected String value;

    public ComponentIdentifier getIdentifier() {
        return this.identifier;
    }

    public ComponentLocation getComponentLocation() {
        return this.componentLocation;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public Optional<Object> getProperty(String name) {
        return Optional.ofNullable(this.properties.get(name));
    }

    public List<ComponentConfiguration> getNestedComponents() {
        return Collections.unmodifiableList(this.nestedComponents);
    }

    protected ComponentConfiguration() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final InternalComponentConfiguration componentConfiguration = new InternalComponentConfiguration();

        public ComponentConfiguration getComponentConfiguration() {
            return this.componentConfiguration;
        }

        private Builder() {
        }

        public Builder withIdentifier(ComponentIdentifier identifier) {
            this.componentConfiguration.identifier = identifier;
            return this;
        }

        public Builder withParameter(String name, String value) {
            this.componentConfiguration.parameters.put(name, value);
            return this;
        }

        public Builder withValue(String textContent) {
            this.componentConfiguration.value = textContent;
            return this;
        }

        public Builder withProperty(String name, Object value) {
            this.componentConfiguration.properties.put(name, value);
            return this;
        }

        public Builder withComponentLocation(ComponentLocation componentLocation) {
            this.componentConfiguration.componentLocation = componentLocation;
            return this;
        }

        public Builder withNestedComponent(ComponentConfiguration nestedComponent) {
            this.componentConfiguration.nestedComponents.add(nestedComponent);
            return this;
        }

        public ComponentConfiguration build() {
            return this.componentConfiguration;
        }
    }
}

