/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.dsl.internal.util.CollectionUtils;
import org.mule.runtime.dsl.internal.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaMappingsUtils {
    public static final String CUSTOM_SCHEMA_MAPPINGS_LOCATION = "META-INF/mule.schemas";
    public static final String CUSTOM_SPRING_SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaMappingsUtils.class);
    private static final LazyValue<Map<String, String>> MULE_SCHEMAS_MAPPINGS = new LazyValue(() -> SchemaMappingsUtils.getSchemaMappings(CUSTOM_SCHEMA_MAPPINGS_LOCATION, SchemaMappingsUtils.class::getClassLoader));
    private static final LazyValue<Map<String, String>> SPRING_SCHEMAS_MAPPINGS = new LazyValue(() -> SchemaMappingsUtils.getSchemaMappings(CUSTOM_SPRING_SCHEMA_MAPPINGS_LOCATION, SchemaMappingsUtils.class::getClassLoader));

    private SchemaMappingsUtils() {
    }

    public static String resolveSystemId(String systemId) {
        if (systemId.equals("http://www.mulesoft.org/schema/mule/core/current/mule.xsd")) {
            return "http://www.mulesoft.org/schema/mule/core/current/mule-core.xsd";
        }
        if (systemId.contains("spring")) {
            return systemId.replace("-current.xsd", ".xsd");
        }
        return systemId;
    }

    public static Map<String, String> getMuleSchemasMappings() {
        return (Map)MULE_SCHEMAS_MAPPINGS.get();
    }

    public static Map<String, String> getSpringSchemasMappings() {
        return (Map)SPRING_SCHEMAS_MAPPINGS.get();
    }

    public static Map<String, String> getSchemaMappings(String schemaMappingsLocation, Supplier<ClassLoader> classLoader) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading schema mappings from [" + schemaMappingsLocation + "]");
        }
        try {
            Properties appPluginsMappings = SchemaMappingsUtils.loadAllProperties(schemaMappingsLocation, classLoader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded schema mappings: " + appPluginsMappings);
            }
            HashMap<String, String> schemaMappings = new HashMap<String, String>(appPluginsMappings.size());
            CollectionUtils.mergePropertiesIntoMap(appPluginsMappings, schemaMappings);
            return schemaMappings;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load schema mappings from location [" + schemaMappingsLocation + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadAllProperties(String resourceName, Supplier<ClassLoader> classLoader) throws IOException {
        ClassLoader classLoaderToUse = classLoader.get();
        Enumeration<URL> urls = classLoaderToUse != null ? classLoaderToUse.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
        Properties props = new Properties();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection con = url.openConnection();
            ResourceUtils.useCachesIfNecessary(con);
            try (InputStream is = con.getInputStream();){
                if (resourceName != null && resourceName.endsWith(".xml")) {
                    props.loadFromXML(is);
                    continue;
                }
                props.load(is);
            }
        }
        return props;
    }
}

