/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.apache.xerces.util.XMLResourceIdentifierImpl;
import org.mule.apache.xerces.xni.XMLResourceIdentifier;
import org.mule.apache.xerces.xni.parser.XMLInputSource;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.dsl.internal.util.SchemaMappingsUtils;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlSchemaProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXmlSchemaProvider
implements XmlSchemaProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlSchemaProvider.class);
    private final Map<String, String> schemas = SchemaMappingsUtils.getMuleSchemasMappings();

    @Override
    public List<XMLInputSource> getSchemas() {
        return this.schemas.entrySet().stream().map(entry -> {
            String systemId = (String)entry.getKey();
            String resourceLocation = (String)entry.getValue();
            XMLInputSource xis = null;
            URL resource = DefaultXmlSchemaProvider.class.getClassLoader().getResource(resourceLocation);
            if (resource == null) {
                LOGGER.debug("Couldn't find schema [{}]: {}", (Object)systemId, (Object)resourceLocation);
            } else {
                try {
                    InputStream is = IOUtils.getInputStreamWithCacheControl((URL)resource);
                    XMLResourceIdentifierImpl resourceIdentifier = new XMLResourceIdentifierImpl();
                    resourceIdentifier.setPublicId(null);
                    resourceIdentifier.setLiteralSystemId(systemId);
                    resourceIdentifier.setBaseSystemId(null);
                    xis = new XMLInputSource((XMLResourceIdentifier)resourceIdentifier);
                    xis.setByteStream(is);
                }
                catch (IOException e) {
                    LOGGER.warn("Error loading XSD [{}]: {}", new Object[]{systemId, resourceLocation, e});
                }
            }
            return Optional.ofNullable(xis);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

