/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.mule.runtime.dsl.api.component.AttributeDefinitionVisitor;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeConverter;

public class AttributeDefinition {
    private String configParameterName;
    private Object defaultValue;
    private boolean hasDefaultValue;
    private boolean undefinedSimpleParametersHolder;
    private Class<?> referenceObject;
    private String referenceFixedParameter;
    private Class<?> childObjectType;
    private boolean undefinedComplexParametersHolder;
    private String referenceSimpleParameter;
    private String softReferenceSimpleParameter;
    private boolean collection;
    private boolean map;
    private Class<?> mapKeyType;
    private boolean valueFromTextContent;
    private TypeConverter typeConverter;
    private KeyAttributeDefinitionPair[] definitions;
    private String wrapperIdentifier;
    private String childIdentifier;
    private boolean referenceConfigurationParameter;

    private AttributeDefinition() {
    }

    public void accept(AttributeDefinitionVisitor visitor) {
        if (this.configParameterName != null) {
            if (this.referenceConfigurationParameter) {
                visitor.onReferenceConfigurationParameter(this.configParameterName, this.defaultValue, Optional.ofNullable(this.typeConverter));
            } else {
                visitor.onConfigurationParameter(this.configParameterName, this.defaultValue, Optional.ofNullable(this.typeConverter));
            }
        } else if (this.referenceObject != null) {
            visitor.onReferenceObject(this.referenceObject);
        } else if (this.undefinedSimpleParametersHolder) {
            visitor.onUndefinedSimpleParameters();
        } else if (this.undefinedComplexParametersHolder) {
            visitor.onUndefinedComplexParameters();
        } else if (this.referenceSimpleParameter != null) {
            visitor.onReferenceSimpleParameter(this.referenceSimpleParameter);
        } else if (this.softReferenceSimpleParameter != null) {
            visitor.onSoftReferenceSimpleParameter(this.softReferenceSimpleParameter);
        } else if (this.referenceFixedParameter != null) {
            visitor.onReferenceFixedParameter(this.referenceFixedParameter);
        } else if (this.childObjectType != null && this.collection) {
            visitor.onComplexChildCollection(this.childObjectType, Optional.ofNullable(this.wrapperIdentifier));
        } else if (this.childObjectType != null && this.map) {
            visitor.onComplexChildMap(this.mapKeyType, this.childObjectType, this.wrapperIdentifier);
        } else if (this.childObjectType != null) {
            Optional<String> wrapperIdentifier = Optional.ofNullable(this.wrapperIdentifier);
            Optional<String> childIdentifier = Optional.ofNullable(this.childIdentifier);
            visitor.onComplexChild(this.childObjectType, wrapperIdentifier, childIdentifier);
        } else if (this.valueFromTextContent) {
            visitor.onValueFromTextContent();
        } else if (this.definitions != null) {
            visitor.onMultipleValues(this.definitions);
        } else if (this.hasDefaultValue) {
            visitor.onFixedValue(this.defaultValue);
        } else {
            throw new RuntimeException();
        }
    }

    static /* synthetic */ KeyAttributeDefinitionPair[] access$1802(AttributeDefinition x0, KeyAttributeDefinitionPair[] x1) {
        x0.definitions = x1;
        return x1;
    }

    public static class Builder {
        private final AttributeDefinition attributeDefinition = new AttributeDefinition();

        private Builder() {
        }

        public static Builder fromSimpleParameter(String configParameterName) {
            Builder builder = new Builder();
            builder.attributeDefinition.configParameterName = configParameterName;
            return builder;
        }

        public static Builder fromSimpleParameter(String configParameterName, TypeConverter typeConverter) {
            Builder builder = new Builder();
            builder.attributeDefinition.configParameterName = configParameterName;
            builder.attributeDefinition.typeConverter = typeConverter;
            return builder;
        }

        public static Builder fromSimpleReferenceParameter(String configParameterName, TypeConverter typeConverter) {
            Builder builder = new Builder();
            builder.attributeDefinition.configParameterName = configParameterName;
            builder.attributeDefinition.typeConverter = typeConverter;
            builder.attributeDefinition.referenceConfigurationParameter = true;
            return builder;
        }

        @Deprecated
        public Builder withDefaultValue(Object defaultValue) {
            this.attributeDefinition.hasDefaultValue = true;
            this.attributeDefinition.defaultValue = defaultValue;
            return this;
        }

        public Builder withWrapperIdentifier(String identifier) {
            Preconditions.checkState((this.attributeDefinition.childObjectType != null ? 1 : 0) != 0, (Object)"Identifier can only be used with children component definitions");
            this.attributeDefinition.wrapperIdentifier = identifier;
            return this;
        }

        public static Builder fromFixedValue(Object value) {
            Builder builder = new Builder();
            builder.attributeDefinition.hasDefaultValue = true;
            builder.attributeDefinition.defaultValue = value;
            return builder;
        }

        public static Builder fromFixedReference(String reference) {
            Builder builder = new Builder();
            builder.attributeDefinition.referenceFixedParameter = reference;
            return builder;
        }

        public static Builder fromUndefinedSimpleAttributes() {
            Builder builder = new Builder();
            builder.attributeDefinition.undefinedSimpleParametersHolder = true;
            return builder;
        }

        public static Builder fromReferenceObject(Class<?> referenceObjectType) {
            Builder builder = new Builder();
            builder.attributeDefinition.referenceObject = referenceObjectType;
            return builder;
        }

        public static Builder fromChildConfiguration(Class<?> childType) {
            Builder builder = new Builder();
            builder.attributeDefinition.childObjectType = childType;
            return builder;
        }

        public static Builder fromUndefinedComplexAttribute() {
            Builder builder = new Builder();
            builder.attributeDefinition.undefinedComplexParametersHolder = true;
            return builder;
        }

        public static Builder fromSimpleReferenceParameter(String referenceSimpleParameter) {
            Builder builder = new Builder();
            builder.attributeDefinition.referenceSimpleParameter = referenceSimpleParameter;
            return builder;
        }

        public static Builder fromSoftReferenceSimpleParameter(String softReferenceParameter) {
            Builder builder = new Builder();
            builder.attributeDefinition.softReferenceSimpleParameter = softReferenceParameter;
            return builder;
        }

        public static Builder fromChildCollectionConfiguration(Class<?> type) {
            Builder builder = new Builder();
            builder.attributeDefinition.childObjectType = type;
            builder.attributeDefinition.collection = true;
            return builder;
        }

        public static Builder fromChildMapConfiguration(Class<?> keyType, Class<?> valueType) {
            Builder builder = new Builder();
            builder.attributeDefinition.childObjectType = valueType;
            builder.attributeDefinition.mapKeyType = keyType;
            builder.attributeDefinition.map = true;
            return builder;
        }

        public static Builder fromTextContent() {
            Builder builder = new Builder();
            builder.attributeDefinition.valueFromTextContent = true;
            return builder;
        }

        public static Builder fromMultipleDefinitions(KeyAttributeDefinitionPair ... definitions) {
            Builder builder = new Builder();
            AttributeDefinition.access$1802(builder.attributeDefinition, definitions);
            return builder;
        }

        public Builder withIdentifier(String childIdentifier) {
            this.attributeDefinition.childIdentifier = childIdentifier;
            return this;
        }

        public AttributeDefinition build() {
            return this.attributeDefinition;
        }
    }
}

