/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;

public class DefaultXmlMetadataAnnotations
implements XmlMetadataAnnotations {
    private static final Pattern URL_PATTERN = Pattern.compile("url=\"[a-z]*://([^@]*)@");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("address=\"[a-z]*://([^@]*)@");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("password=\"([^\"|\n]*)\"");
    private static final String PASSWORD_MASK = "@@credentials@@";
    private static final String PASSWORD_ATTRIBUTE_MASK = "password=\"%s\"";
    private final StringBuilder xmlContent = new StringBuilder();
    private final XmlMetadataAnnotations.TagBoundaries openingTagBoundaries = new DefaultTagBoundaries();
    private final XmlMetadataAnnotations.TagBoundaries closingTagBoundaries = new DefaultTagBoundaries();

    @Override
    public void appendElementStart(String qName, Map<String, String> atts) {
        this.xmlContent.append("<").append(qName);
        for (Map.Entry<String, String> entry : atts.entrySet()) {
            if (entry.getKey().equals("url") || entry.getKey().equals("address") || entry.getKey().equals("password")) {
                this.xmlContent.append(DefaultXmlMetadataAnnotations.maskPasswords(" " + entry.getKey() + "=\"" + entry.getValue() + "\""));
                continue;
            }
            this.xmlContent.append(" ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        this.xmlContent.append(">");
    }

    @Override
    public void appendElementBody(String elementBody) {
        String trimmedBody = elementBody.trim();
        if (trimmedBody.startsWith("<") && trimmedBody.endsWith(">")) {
            if (this.xmlContent.charAt(this.xmlContent.length() - 1) == '>') {
                this.xmlContent.append(System.lineSeparator());
            }
            this.xmlContent.append(trimmedBody).append(System.lineSeparator());
        } else {
            this.xmlContent.append(trimmedBody);
        }
    }

    @Override
    public void appendElementEnd(String qName) {
        this.xmlContent.append("</").append(qName).append(">");
    }

    @Override
    public String getElementString() {
        return this.xmlContent.toString();
    }

    @Override
    public boolean isSelfClosing() {
        return this.openingTagBoundaries.getStartLineNumber() == this.closingTagBoundaries.getStartLineNumber() && this.openingTagBoundaries.getStartColumnNumber() == this.closingTagBoundaries.getStartColumnNumber();
    }

    @Override
    public XmlMetadataAnnotations.TagBoundaries getOpeningTagBoundaries() {
        return this.openingTagBoundaries;
    }

    @Override
    public XmlMetadataAnnotations.TagBoundaries getClosingTagBoundaries() {
        return this.closingTagBoundaries;
    }

    private static String maskPasswords(String xml, String passwordMask) {
        xml = DefaultXmlMetadataAnnotations.maskUrlPassword(xml, URL_PATTERN, passwordMask);
        Matcher matcher = PASSWORD_PATTERN.matcher(xml = DefaultXmlMetadataAnnotations.maskUrlPassword(xml, ADDRESS_PATTERN, passwordMask));
        if (matcher.find() && matcher.groupCount() > 0) {
            xml = xml.replaceAll(Pattern.quote(DefaultXmlMetadataAnnotations.maskPasswordAttribute(matcher.group(1))), DefaultXmlMetadataAnnotations.maskPasswordAttribute(passwordMask));
        }
        xml = DefaultXmlMetadataAnnotations.maskUrlPassword(xml, PASSWORD_PATTERN, passwordMask);
        return xml;
    }

    private static String maskPasswords(String xml) {
        return DefaultXmlMetadataAnnotations.maskPasswords(xml, PASSWORD_MASK);
    }

    private static String maskUrlPassword(String xml, Pattern pattern, String passwordMask) {
        Matcher matcher = pattern.matcher(xml);
        if (matcher.find() && matcher.groupCount() > 0) {
            xml = xml.replaceAll(Pattern.quote(matcher.group(1)), passwordMask);
        }
        return xml;
    }

    private static String maskPasswordAttribute(String password) {
        return String.format(PASSWORD_ATTRIBUTE_MASK, password);
    }

    private static class DefaultTagBoundaries
    implements XmlMetadataAnnotations.TagBoundaries {
        private int startLineNumber;
        private int startColumnNumber;
        private int endLineNumber;
        private int endColumnNumber;

        private DefaultTagBoundaries() {
        }

        @Override
        public int getStartLineNumber() {
            return this.startLineNumber;
        }

        @Override
        public void setStartLineNumber(int lineNumber) {
            this.startLineNumber = lineNumber;
        }

        @Override
        public int getStartColumnNumber() {
            return this.startColumnNumber;
        }

        @Override
        public void setStartColumnNumber(int columnNumber) {
            this.startColumnNumber = columnNumber;
        }

        @Override
        public int getEndLineNumber() {
            return this.endLineNumber;
        }

        @Override
        public void setEndLineNumber(int lineNumber) {
            this.endLineNumber = lineNumber;
        }

        @Override
        public int getEndColumnNumber() {
            return this.endColumnNumber;
        }

        @Override
        public void setEndColumnNumber(int columnNumber) {
            this.endColumnNumber = columnNumber;
        }
    }
}

