/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.dsl.api.component.AnnotatedObjectFactory;

public abstract class AbstractAnnotatedObjectFactory<T>
implements AnnotatedObjectFactory<T> {
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

    public final Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public ComponentLocation getLocation() {
        return (ComponentLocation)this.getAnnotation(AbstractAnnotatedObject.LOCATION_KEY);
    }

    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }

    public abstract T doGetObject() throws Exception;

    @Override
    public T getObject() throws Exception {
        T annotatedInstance = this.doGetObject();
        if (annotatedInstance instanceof AnnotatedObject) {
            ((AnnotatedObject)annotatedInstance).setAnnotations(this.getAnnotations());
        }
        return annotatedInstance;
    }
}

