/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.singleapp;

import java.util.List;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.internal.ArtifactDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.mule.runtime.module.deployment.internal.DefaultArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentMuleContextListenerFactory;
import org.mule.runtime.module.deployment.internal.DomainArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DomainDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.util.ObservableList;

public class SingleAppDomainDeployerBuilder {
    private final Supplier<SchedulerService> artifactStartExecutorSupplier;
    private ObservableList<Domain> domains;
    private ArtifactDeployer<Domain> domainArtifactDeployer;
    private DefaultDomainFactory domainFactory;
    private DefaultArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer;
    private CompositeDeploymentListener applicationDeploymentListener;
    private CompositeDeploymentListener domainDeploymentListener;
    private DeploymentService deploymentService;
    private ObservableList<Application> applications;
    private DefaultApplicationFactory applicationFactory;
    private ArtifactDeployer<Application> applicationArtifactDeployer;

    private SingleAppDomainDeployerBuilder(Supplier<SchedulerService> artifactStartExecutorSupplier) {
        this.artifactStartExecutorSupplier = artifactStartExecutorSupplier;
    }

    public static SingleAppDomainDeployerBuilder getSingleAppDomainDeployerBuilder(Supplier<SchedulerService> artifactStartExecutorSupplier) {
        return new SingleAppDomainDeployerBuilder(artifactStartExecutorSupplier);
    }

    public DomainArchiveDeployer build() {
        return new DomainArchiveDeployer(new DefaultArchiveDeployer<DomainDescriptor, Domain>(this.domainArtifactDeployer, (AbstractDeployableArtifactFactory<DomainDescriptor, Domain>)this.domainFactory, this.domains, new DomainDeploymentTemplate(new DefaultArchiveDeployer<ApplicationDescriptor, Application>(this.applicationArtifactDeployer, (AbstractDeployableArtifactFactory<ApplicationDescriptor, Application>)this.applicationFactory, this.applications, ArtifactDeploymentTemplate.NOP_ARTIFACT_DEPLOYMENT_TEMPLATE, new DeploymentMuleContextListenerFactory(this.applicationDeploymentListener), this.artifactStartExecutorSupplier), this.deploymentService, this.applicationDeploymentListener), new DeploymentMuleContextListenerFactory(this.domainDeploymentListener), this.artifactStartExecutorSupplier), this.applicationDeployer, this.deploymentService);
    }

    public SingleAppDomainDeployerBuilder withDomains(List<Domain> domains) {
        this.domains = new ObservableList<Domain>(domains);
        return this;
    }

    public SingleAppDomainDeployerBuilder withApplications(List<Application> applications) {
        this.applications = new ObservableList<Application>(applications);
        return this;
    }

    public SingleAppDomainDeployerBuilder withApplicationFactory(DefaultApplicationFactory applicationFactory) {
        this.applicationFactory = applicationFactory;
        return this;
    }

    public SingleAppDomainDeployerBuilder withApplicationArtifactDeployer(ArtifactDeployer<Application> applicationArtifactDeployer) {
        this.applicationArtifactDeployer = applicationArtifactDeployer;
        return this;
    }

    public SingleAppDomainDeployerBuilder withDomainArtifactDeployer(ArtifactDeployer<Domain> domainArtifactDeployer) {
        this.domainArtifactDeployer = domainArtifactDeployer;
        return this;
    }

    public SingleAppDomainDeployerBuilder withDomainFactory(DefaultDomainFactory domainFactory) {
        this.domainFactory = domainFactory;
        return this;
    }

    public SingleAppDomainDeployerBuilder withApplicationDeploymentListener(CompositeDeploymentListener applicationDeploymentListener) {
        this.applicationDeploymentListener = applicationDeploymentListener;
        return this;
    }

    public SingleAppDomainDeployerBuilder withDomainDeploymentListener(CompositeDeploymentListener domainDeploymentListener) {
        this.domainDeploymentListener = domainDeploymentListener;
        return this;
    }

    public SingleAppDomainDeployerBuilder withApplicationDeployer(DefaultArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer) {
        this.applicationDeployer = applicationDeployer;
        return this;
    }

    public SingleAppDomainDeployerBuilder withDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
        return this;
    }
}

