/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.module.deployment.internal.ActionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibrariesFolderDeletionActionTask
implements ActionTask {
    private final String applicationName;
    private final File appNativeLibrariesFolder;
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLibrariesFolderDeletionActionTask.class);

    public NativeLibrariesFolderDeletionActionTask(String applicationName, File appNativeLibrariesFolder) {
        this.applicationName = applicationName;
        this.appNativeLibrariesFolder = appNativeLibrariesFolder;
    }

    @Override
    public boolean tryAction() {
        boolean actionPerformed = true;
        try {
            FileUtils.deleteDirectory((File)this.appNativeLibrariesFolder);
            LOGGER.debug("App Native Libraries folder deleted: {}", (Object)this.appNativeLibrariesFolder.getAbsolutePath());
        }
        catch (Throwable e) {
            LOGGER.warn(String.format("Cannot delete App Native Libraries folder '%s' from artifact '%s'. This could be related to some files still being used. Exception: %s", this.appNativeLibrariesFolder, this.applicationName, e.getMessage()));
            actionPerformed = false;
        }
        return actionPerformed;
    }
}

