/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.processor;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationUtils;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.ApplicationFilteredFromPolicyArtifactAst;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContextConfiguration;
import org.mule.runtime.module.artifact.activation.api.ast.ArtifactAstUtils;
import org.mule.runtime.module.deployment.internal.processor.AbstractAstConfigurationProcessor;

public final class AstXmlParserArtifactConfigurationProcessor
extends AbstractAstConfigurationProcessor {
    @Override
    protected ArtifactAst obtainArtifactAst(ArtifactContextConfiguration artifactContextConfiguration) throws ConfigurationException {
        return this.createApplicationModel(artifactContextConfiguration.getMuleContext(), artifactContextConfiguration.getArtifactDeclaration(), artifactContextConfiguration.getConfigResources(), artifactContextConfiguration.getArtifactProperties(), artifactContextConfiguration.getArtifactType(), artifactContextConfiguration.getParentArtifactContext().map(ArtifactContext::getArtifactAst).orElse(MuleAstUtils.emptyArtifact()), artifactContextConfiguration.isDisableXmlValidations(), artifactContextConfiguration.getExpressionLanguageMetadataService());
    }

    private Set<ExtensionModel> getExtensions(ExtensionManager extensionManager) {
        return extensionManager == null ? Collections.emptySet() : extensionManager.getExtensions();
    }

    private ArtifactAst createApplicationModel(MuleContext muleContext, ArtifactDeclaration artifactDeclaration, String[] artifactConfigResources, Map<String, String> artifactProperties, ArtifactType artifactType, ArtifactAst parentArtifactAst, boolean disableXmlValidations, ExpressionLanguageMetadataService expressionLanguageMetadataService) throws ConfigurationException {
        Set<ExtensionModel> extensions = this.getExtensions(muleContext.getExtensionManager());
        try {
            ArtifactAst artifactAst = artifactDeclaration == null ? (artifactConfigResources.length == 0 ? MuleAstUtils.emptyArtifact() : ArtifactAstUtils.parseAndBuildAppExtensionModel((String)muleContext.getConfiguration().getId(), (String[])artifactConfigResources, (exts, disableValidations) -> this.createMuleXmlParser(muleContext, exts, artifactProperties, artifactType, parentArtifactAst, disableValidations), extensions, (boolean)disableXmlValidations, (ClassLoader)muleContext.getExecutionClassLoader(), (MuleConfiguration)muleContext.getConfiguration(), (ExpressionLanguageMetadataService)expressionLanguageMetadataService)) : ArtifactDeclarationUtils.toArtifactast((ArtifactDeclaration)artifactDeclaration, extensions);
            return artifactAst;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private AstXmlParser createMuleXmlParser(MuleContext muleContext, Set<ExtensionModel> extensions, Map<String, String> artifactProperties, ArtifactType artifactType, ArtifactAst parentArtifactAst, boolean disableXmlValidations) {
        ConfigurationPropertiesResolver propertyResolver = new ConfigurationPropertiesHierarchyBuilder().withApplicationProperties(artifactProperties).build();
        FeatureFlaggingService featureFlaggingService = this.getFeatureFlaggingService(muleContext);
        AstXmlParser.Builder builder = AstXmlParser.builder().withPropertyResolver(propertyKey -> (String)propertyResolver.resolveValue(propertyKey)).withExtensionModels(extensions).withArtifactType(this.toAstArtifactType(artifactType)).withParentArtifact(this.resolveParentArtifact(parentArtifactAst, artifactType, featureFlaggingService));
        if (!featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)) {
            builder.withLegacyFailStrategy();
        }
        if (disableXmlValidations) {
            builder.withSchemaValidationsDisabled();
        }
        return builder.build();
    }

    private org.mule.runtime.ast.api.ArtifactType toAstArtifactType(ArtifactType artifactType) {
        switch (artifactType) {
            case APP: {
                return org.mule.runtime.ast.api.ArtifactType.APPLICATION;
            }
            case DOMAIN: {
                return org.mule.runtime.ast.api.ArtifactType.DOMAIN;
            }
            case POLICY: {
                return org.mule.runtime.ast.api.ArtifactType.POLICY;
            }
        }
        throw new IllegalArgumentException("The provided artifact type '" + artifactType + "' cannot be deployed.");
    }

    private FeatureFlaggingService getFeatureFlaggingService(MuleContext muleContext) {
        Registry originalRegistry = ((MuleRegistryHelper)((MuleContextWithRegistry)muleContext).getRegistry()).getDelegate();
        return (FeatureFlaggingService)originalRegistry.lookupObject("core.featureFlaggingService");
    }

    private ArtifactAst resolveParentArtifact(ArtifactAst parentArtifactAst, ArtifactType artifactType, FeatureFlaggingService featureFlaggingService) {
        if (ArtifactType.POLICY.equals((Object)artifactType)) {
            return ApplicationFilteredFromPolicyArtifactAst.applicationFilteredFromPolicyArtifactAst((ArtifactAst)parentArtifactAst, (FeatureFlaggingService)featureFlaggingService);
        }
        return parentArtifactAst;
    }
}

