/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.module.deployment.internal.ActionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibrariesFolderDeletionRetryScheduledTask
implements Runnable,
ActionTask {
    private final ScheduledExecutorService scheduler;
    private final int maxAttempts;
    private final AtomicInteger attempts;
    private final ActionTask actionTask;
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLibrariesFolderDeletionRetryScheduledTask.class);
    private static final boolean DISABLE_NATIVE_LIBRARIES_FOLDER_DELETION_GC_CALL = Boolean.parseBoolean(System.getProperty("mule.disable.nativeLibrariesFolderDeletion.gc.call", "false"));

    public NativeLibrariesFolderDeletionRetryScheduledTask(ScheduledExecutorService scheduler, int maxAttempts, ActionTask actionTask) {
        this.scheduler = scheduler;
        this.maxAttempts = maxAttempts;
        this.attempts = new AtomicInteger(0);
        this.actionTask = actionTask;
    }

    @Override
    public void run() {
        boolean secondToLastAttempt;
        int attempt = this.attempts.incrementAndGet();
        boolean bl = secondToLastAttempt = attempt == this.maxAttempts - 1;
        if (!DISABLE_NATIVE_LIBRARIES_FOLDER_DELETION_GC_CALL && secondToLastAttempt) {
            System.gc();
            LOGGER.debug("Attempt {}. System.gc() executed.", (Object)attempt);
        }
        if (this.tryAction()) {
            this.scheduler.shutdown();
        } else if (attempt >= this.maxAttempts) {
            LOGGER.error("Failed to perform the action. No further retries will be made.");
            this.scheduler.shutdown();
        } else {
            LOGGER.warn("Attempt {}. Failed to perform the action. Retrying...", (Object)attempt);
        }
    }

    @Override
    public boolean tryAction() {
        return this.actionTask.tryAction();
    }
}

