/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentDirectoryWatcher;
import org.mule.runtime.module.deployment.internal.DomainBundleArchiveDeployer;
import org.mule.runtime.module.deployment.internal.util.ObservableList;

public class ParallelDeploymentDirectoryWatcher
extends DeploymentDirectoryWatcher {
    public static final int MAX_APPS_IN_PARALLEL_DEPLOYMENT = 20;
    private Scheduler threadPoolExecutor;

    public ParallelDeploymentDirectoryWatcher(Optional<Properties> additionalDeploymentProperties, DomainBundleArchiveDeployer domainBundleDeployer, ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer, ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer, ObservableList<Domain> domains, ObservableList<Application> applications, Supplier<SchedulerService> schedulerServiceSupplier, ReentrantLock deploymentLock) {
        super(additionalDeploymentProperties, domainBundleDeployer, domainArchiveDeployer, applicationArchiveDeployer, domains, applications, schedulerServiceSupplier, deploymentLock);
    }

    @Override
    protected void deployPackedApps(Collection<Path> zips) {
        if (zips.isEmpty()) {
            return;
        }
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(zips.size());
        for (Path zip : zips) {
            tasks.add(() -> {
                try {
                    this.applicationArchiveDeployer.deployPackagedArtifact(zip, Optional.empty());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
        }
        this.waitForTasksToFinish(tasks);
    }

    @Override
    protected void deployExplodedApps(List<Path> apps) {
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(apps.size());
        apps.forEach(addedApp -> {
            if (this.applicationArchiveDeployer.isUpdatedZombieArtifact(addedApp.getFileName().toString())) {
                tasks.add(() -> {
                    try {
                        this.applicationArchiveDeployer.deployExplodedArtifact((Path)addedApp, Optional.empty());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                });
            }
        });
        if (!tasks.isEmpty()) {
            this.waitForTasksToFinish(tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTasksToFinish(List<Callable<Object>> tasks) {
        this.threadPoolExecutor = ((SchedulerService)this.schedulerServiceSupplier.get()).ioScheduler(SchedulerConfig.config().withName("parallelDeployment").withMaxConcurrentTasks(20));
        try {
            List futures = this.threadPoolExecutor.invokeAll(tasks);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {}
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.threadPoolExecutor.stop();
        }
    }
}

