/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DeploymentUtils.class);

    public static List<Path> listFiles(Path directory, Predicate<Path> filter) {
        List<Path> list;
        block8: {
            Stream<Path> content = Files.list(directory);
            try {
                list = content.filter(filter).toList();
                if (content == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("We got a null while listing the contents of directory '%s'. Some common causes for this is a lack of permissions to the directory or that it's being deleted concurrently", directory.getFileName()), e);
                }
            }
            content.close();
        }
        return list;
    }

    public static void deployExplodedDomains(ArchiveDeployer<DomainDescriptor, Domain> domainDeployer) {
        List<Path> domains = DeploymentUtils.listFiles(domainDeployer.getDeploymentDirectoryPath(), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        DeploymentUtils.deployExplodedDomains(domainDeployer, domains, Optional.empty());
    }

    public static void deployExplodedDomains(ArchiveDeployer<DomainDescriptor, Domain> domainDeployer, List<Path> domains, Optional<Properties> additionalDeploymentProperties) {
        domains.stream().filter(domain -> !DeploymentUtils.isDefaultDomainDirectory(domain)).forEach(addedDomain -> {
            try {
                if (domainDeployer.isUpdatedZombieArtifact(addedDomain.getFileName().toString())) {
                    domainDeployer.deployExplodedArtifact((Path)addedDomain, additionalDeploymentProperties);
                }
            }
            catch (DeploymentException e) {
                LOGGER.error("Error deploying domain '{}'", addedDomain, (Object)e);
            }
        });
    }

    private static boolean isDefaultDomainDirectory(Path domainPath) {
        return Files.isDirectory(domainPath, new LinkOption[0]) && "default".equalsIgnoreCase(domainPath.getFileName().toString());
    }
}

