/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.internal.config.StartupContext;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.StartupListener;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.MuleContextListenerFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.mule.runtime.module.deployment.internal.DefaultArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DefaultArtifactDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentDirectoryWatcher;
import org.mule.runtime.module.deployment.internal.DeploymentMuleContextListenerFactory;
import org.mule.runtime.module.deployment.internal.DeploymentStatusTracker;
import org.mule.runtime.module.deployment.internal.DomainArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DomainDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.ParallelDeploymentDirectoryWatcher;
import org.mule.runtime.module.deployment.internal.StartupSummaryDeploymentListener;
import org.mule.runtime.module.deployment.internal.util.DebuggableReentrantLock;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.mule.runtime.module.service.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleDeploymentService
implements DeploymentService {
    public static final String ARTIFACT_ANCHOR_SUFFIX = "-anchor.txt";
    public static final IOFileFilter JAR_ARTIFACT_FILTER = new AndFileFilter((IOFileFilter)new SuffixFileFilter(".jar"), FileFileFilter.FILE);
    public static final String PARALLEL_DEPLOYMENT_PROPERTY = "mule.deployment.parallel";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReentrantLock deploymentLock = new DebuggableReentrantLock(true);
    private final ObservableList<Application> applications = new ObservableList();
    private final ObservableList<Domain> domains = new ObservableList();
    private final List<StartupListener> startupListeners = new ArrayList<StartupListener>();
    private final CompositeDeploymentListener applicationDeploymentListener = new CompositeDeploymentListener();
    private final CompositeDeploymentListener domainDeploymentListener = new CompositeDeploymentListener();
    private final ArchiveDeployer<Domain> domainDeployer;
    private final DeploymentDirectoryWatcher deploymentDirectoryWatcher;
    private DefaultArchiveDeployer<Application> applicationDeployer;

    public MuleDeploymentService(DefaultDomainFactory domainFactory, DefaultApplicationFactory applicationFactory, Supplier<SchedulerService> schedulerServiceSupplier) {
        domainFactory.setMuleContextListenerFactory((MuleContextListenerFactory)new DeploymentMuleContextListenerFactory(this.domainDeploymentListener));
        applicationFactory.setMuleContextListenerFactory((MuleContextListenerFactory)new DeploymentMuleContextListenerFactory(this.applicationDeploymentListener));
        DefaultArtifactDeployer applicationMuleDeployer = new DefaultArtifactDeployer();
        DefaultArtifactDeployer domainMuleDeployer = new DefaultArtifactDeployer();
        this.applicationDeployer = new DefaultArchiveDeployer<Application>(applicationMuleDeployer, (ArtifactFactory)applicationFactory, this.applications, ArtifactDeploymentTemplate.NOP_ARTIFACT_DEPLOYMENT_TEMPLATE);
        this.applicationDeployer.setDeploymentListener(this.applicationDeploymentListener);
        this.domainDeployer = new DomainArchiveDeployer(new DefaultArchiveDeployer<Domain>(domainMuleDeployer, (ArtifactFactory)domainFactory, this.domains, new DomainDeploymentTemplate(this.applicationDeployer, this)), this.applicationDeployer, this);
        this.domainDeployer.setDeploymentListener(this.domainDeploymentListener);
        if (this.useParallelDeployment()) {
            if (this.isDeployingSelectedAppsInOrder()) {
                throw new IllegalArgumentException("Deployment parameters 'app' and 'mule.deployment.parallel' cannot be used together");
            }
            this.logger.info("Using parallel deployment");
            this.deploymentDirectoryWatcher = new ParallelDeploymentDirectoryWatcher(this.domainDeployer, this.applicationDeployer, this.domains, this.applications, schedulerServiceSupplier, this.deploymentLock);
        } else {
            this.deploymentDirectoryWatcher = new DeploymentDirectoryWatcher(this.domainDeployer, this.applicationDeployer, this.domains, this.applications, schedulerServiceSupplier, this.deploymentLock);
        }
    }

    private boolean useParallelDeployment() {
        return System.getProperties().containsKey(PARALLEL_DEPLOYMENT_PROPERTY);
    }

    private boolean isDeployingSelectedAppsInOrder() {
        Map options = StartupContext.get().getStartupOptions();
        String appString = (String)options.get("app");
        return !StringUtils.isEmpty((CharSequence)appString);
    }

    @Override
    public void start() {
        DeploymentStatusTracker deploymentStatusTracker = new DeploymentStatusTracker();
        this.addDeploymentListener(deploymentStatusTracker.getApplicationDeploymentStatusTracker());
        this.addDomainDeploymentListener(deploymentStatusTracker.getDomainDeploymentStatusTracker());
        StartupSummaryDeploymentListener summaryDeploymentListener = new StartupSummaryDeploymentListener(deploymentStatusTracker, this);
        this.addStartupListener(summaryDeploymentListener);
        this.deploymentDirectoryWatcher.start();
        for (StartupListener listener : this.startupListeners) {
            try {
                listener.onAfterStartup();
            }
            catch (Throwable t) {
                this.logger.error("Error executing startup listener {}", (Object)listener, (Object)t);
            }
        }
    }

    @Override
    public void stop() {
        this.deploymentDirectoryWatcher.stop();
    }

    @Override
    public Domain findDomain(String domainName) {
        return this.deploymentDirectoryWatcher.findArtifact(domainName, this.domains);
    }

    @Override
    public Application findApplication(String appName) {
        return this.deploymentDirectoryWatcher.findArtifact(appName, this.applications);
    }

    @Override
    public Collection<Application> findDomainApplications(String domain) {
        Preconditions.checkArgument((domain != null ? 1 : 0) != 0, (String)"Domain name cannot be null");
        return CollectionUtils.select(this.applications, object -> ((Application)object).getDomain().getArtifactName().equals(domain));
    }

    @Override
    public List<Application> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    @Override
    public List<Domain> getDomains() {
        return Collections.unmodifiableList(this.domains);
    }

    Map<URI, Long> getZombieApplications() {
        return this.applicationDeployer.getArtifactsZombieMap();
    }

    Map<URI, Long> getZombieDomains() {
        return this.domainDeployer.getArtifactsZombieMap();
    }

    public void setAppFactory(ArtifactFactory<Application> appFactory) {
        this.applicationDeployer.setArtifactFactory(appFactory);
    }

    @Override
    public ReentrantLock getLock() {
        return this.deploymentLock;
    }

    @Override
    public void undeploy(String appName) {
        this.executeSynchronized(() -> this.applicationDeployer.undeployArtifact(appName));
    }

    @Override
    public void deploy(URI appArchiveUri) throws IOException {
        this.executeSynchronized(() -> {
            block6: {
                try {
                    File appLocation = FileUtils.toFile((URL)appArchiveUri.toURL());
                    String fileName = appLocation.getName();
                    if (fileName.endsWith(".jar")) {
                        this.applicationDeployer.deployPackagedArtifact(appArchiveUri);
                        break block6;
                    }
                    if (!appLocation.getParent().equals(MuleFoldersUtil.getAppsFolder())) {
                        try {
                            FileUtils.copyDirectory((File)appLocation, (File)new File(MuleFoldersUtil.getAppsFolder(), fileName));
                        }
                        catch (IOException e) {
                            throw new MuleRuntimeException((Throwable)e);
                        }
                    }
                    this.applicationDeployer.deployExplodedArtifact(fileName);
                }
                catch (MalformedURLException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
        });
    }

    @Override
    public void redeploy(String artifactName) {
        this.executeSynchronized(() -> {
            block2: {
                try {
                    this.applicationDeployer.redeploy(this.findApplication(artifactName));
                }
                catch (DeploymentException e) {
                    if (!this.logger.isDebugEnabled()) break block2;
                    this.logger.debug("Failure while redeploying application: " + artifactName, (Throwable)e);
                }
            }
        });
    }

    @Override
    public void undeployDomain(String domainName) {
        this.executeSynchronized(() -> this.domainDeployer.undeployArtifact(domainName));
    }

    @Override
    public void deployDomain(URI domainArchiveUri) throws IOException {
        this.executeSynchronized(() -> this.domainDeployer.deployPackagedArtifact(domainArchiveUri));
    }

    @Override
    public void redeployDomain(String domainName) {
        this.executeSynchronized(() -> this.domainDeployer.redeploy(this.findDomain(domainName)));
    }

    @Override
    public void addStartupListener(StartupListener listener) {
        this.startupListeners.add(listener);
    }

    @Override
    public void removeStartupListener(StartupListener listener) {
        this.startupListeners.remove(listener);
    }

    @Override
    public void addDeploymentListener(DeploymentListener listener) {
        this.applicationDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDeploymentListener(DeploymentListener listener) {
        this.applicationDeploymentListener.removeDeploymentListener(listener);
    }

    @Override
    public void addDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.addDeploymentListener(listener);
    }

    @Override
    public void removeDomainDeploymentListener(DeploymentListener listener) {
        this.domainDeploymentListener.removeDeploymentListener(listener);
    }

    public void setDomainFactory(ArtifactFactory<Domain> domainFactory) {
        this.domainDeployer.setArtifactFactory(domainFactory);
    }

    void undeploy(Application app) {
        this.applicationDeployer.undeployArtifact(app.getArtifactName());
    }

    void undeploy(Domain domain) {
        this.domainDeployer.undeployArtifact(domain.getArtifactName());
    }

    private void executeSynchronized(SynchronizedDeploymentAction deploymentAction) {
        try {
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Another deployment operation in progress, will skip this cycle. Owner thread: " + (this.deploymentLock instanceof DebuggableReentrantLock ? ((DebuggableReentrantLock)this.deploymentLock).getOwner() : "Unknown"));
                }
                return;
            }
            deploymentAction.execute();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    public static SchedulerService findSchedulerService(ServiceManager serviceManager) {
        List services = serviceManager.getServices();
        return (SchedulerService)services.stream().filter(s -> s instanceof SchedulerService).findFirst().get();
    }

    private static interface SynchronizedDeploymentAction {
        public void execute();
    }
}

