/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.api.artifact.extension;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionModelLoaderRepository;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.artifact.extension.DefaultExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;

public interface ExtensionDiscoveryRequest {
    public static ExtensionDiscoveryRequestBuilder builder() {
        return new ExtensionDiscoveryRequestBuilder();
    }

    public ExtensionModelLoaderRepository getLoaderRepository();

    public List<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>> getArtifactPlugins();

    public Set<ExtensionModel> getParentArtifactExtensions();

    public boolean isParallelDiscovery();

    public boolean isEnrichDescriptions();

    public static final class ExtensionDiscoveryRequestBuilder {
        private ExtensionModelLoaderRepository loaderRepository;
        private List<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>> artifactPlugins;
        private Set<ExtensionModel> parentArtifactExtensions = Collections.emptySet();
        private boolean parallelDiscovery = false;
        private boolean enrichDescriptions = true;

        public ExtensionDiscoveryRequestBuilder setLoaderRepository(ExtensionModelLoaderRepository loaderRepository) {
            this.loaderRepository = loaderRepository;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setArtifactPlugins(List<Pair<ArtifactPluginDescriptor, ArtifactClassLoader>> artifactPlugins) {
            this.artifactPlugins = artifactPlugins;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setParentArtifactExtensions(Set<ExtensionModel> parentArtifactExtensions) {
            this.parentArtifactExtensions = parentArtifactExtensions;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setEnrichDescriptions(boolean enrichDescriptions) {
            this.enrichDescriptions = enrichDescriptions;
            return this;
        }

        public ExtensionDiscoveryRequestBuilder setParallelDiscovery(boolean parallelDiscovery) {
            this.parallelDiscovery = parallelDiscovery;
            return this;
        }

        public ExtensionDiscoveryRequest build() {
            return new DefaultExtensionDiscoveryRequest(this.loaderRepository, this.artifactPlugins, this.parentArtifactExtensions, this.parallelDiscovery, this.enrichDescriptions);
        }
    }
}

