/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.ChildOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DelegateOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegionPluginClassLoadersFactory
implements RegionPluginClassLoadersFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegionPluginClassLoadersFactory.class);
    public static final String PLUGIN_CLASSLOADER_IDENTIFIER = "/plugin/";
    private final ArtifactClassLoaderFactory artifactPluginClassLoaderFactory;
    private final ModuleRepository moduleRepository;

    public DefaultRegionPluginClassLoadersFactory(ArtifactClassLoaderFactory artifactPluginClassLoaderFactory, ModuleRepository moduleRepository) {
        Preconditions.checkArgument((artifactPluginClassLoaderFactory != null ? 1 : 0) != 0, (String)"artifactPluginClassLoaderFactory cannot be null");
        Preconditions.checkArgument((moduleRepository != null ? 1 : 0) != 0, (String)"moduleRepository cannot be null");
        this.artifactPluginClassLoaderFactory = artifactPluginClassLoaderFactory;
        this.moduleRepository = moduleRepository;
    }

    @Override
    public List<ArtifactClassLoader> createPluginClassLoaders(ArtifactClassLoader regionClassLoader, List<ArtifactPluginDescriptor> artifactPluginDescriptors, ClassLoaderLookupPolicy regionOwnerLookupPolicy) {
        LinkedList<ArtifactClassLoader> classLoaders = new LinkedList<ArtifactClassLoader>();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : artifactPluginDescriptors) {
            String pluginArtifactId = DefaultRegionPluginClassLoadersFactory.getArtifactPluginId(regionClassLoader.getArtifactId(), artifactPluginDescriptor.getName());
            ClassLoaderLookupPolicy pluginLookupPolicy = this.createPluginLookupPolicy(classLoaders, artifactPluginDescriptor, regionOwnerLookupPolicy, artifactPluginDescriptors);
            ArtifactClassLoader artifactClassLoader = this.artifactPluginClassLoaderFactory.create(pluginArtifactId, (ArtifactDescriptor)artifactPluginDescriptor, regionClassLoader.getClassLoader(), pluginLookupPolicy);
            classLoaders.add(artifactClassLoader);
        }
        return classLoaders;
    }

    public static String getArtifactPluginId(String parentArtifactId, String pluginName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)parentArtifactId) ? 1 : 0) != 0, (String)"parentArtifactId cannot be empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)pluginName) ? 1 : 0) != 0, (String)"pluginName cannot be empty");
        return parentArtifactId + PLUGIN_CLASSLOADER_IDENTIFIER + pluginName;
    }

    private ClassLoaderLookupPolicy createPluginLookupPolicy(List<ArtifactClassLoader> classLoaders, ArtifactPluginDescriptor descriptor, ClassLoaderLookupPolicy baseLookupPolicy, List<ArtifactPluginDescriptor> artifactPluginDescriptors) {
        HashMap<String, Object> pluginsLookupPolicies = new HashMap<String, Object>();
        List<ArtifactPluginDescriptor> pluginDescriptors = this.getPluginDescriptors(descriptor, artifactPluginDescriptors);
        for (ArtifactPluginDescriptor dependencyPluginDescriptor : pluginDescriptors) {
            Iterator exportedPackage2;
            if (dependencyPluginDescriptor.getName().equals(descriptor.getName())) continue;
            Object lookupStrategy = this.getClassLoaderLookupStrategy(descriptor, dependencyPluginDescriptor);
            for (Iterator exportedPackage2 : dependencyPluginDescriptor.getClassLoaderModel().getExportedPackages()) {
                pluginsLookupPolicies.put((String)((Object)exportedPackage2), lookupStrategy);
            }
            if (!this.isPrivilegedPluginDependency(descriptor, dependencyPluginDescriptor)) continue;
            Optional<ArtifactClassLoader> pluginClassLoader = classLoaders.stream().filter(c -> c.getArtifactDescriptor().getBundleDescriptor().getArtifactId().equals(dependencyPluginDescriptor.getBundleDescriptor().getArtifactId())).findFirst();
            if (!pluginClassLoader.isPresent()) {
                throw new IllegalStateException("Cannot find classloader for plugin: " + dependencyPluginDescriptor.getBundleDescriptor().getArtifactId());
            }
            lookupStrategy = new DelegateOnlyLookupStrategy(pluginClassLoader.get().getClassLoader());
            exportedPackage2 = dependencyPluginDescriptor.getClassLoaderModel().getPrivilegedExportedPackages().iterator();
            while (exportedPackage2.hasNext()) {
                String exportedPackage3 = (String)exportedPackage2.next();
                pluginsLookupPolicies.put(exportedPackage3, lookupStrategy);
            }
        }
        ContainerOnlyLookupStrategy containerOnlyLookupStrategy = new ContainerOnlyLookupStrategy(this.getClass().getClassLoader());
        HashSet muleModulesExportedPackages = new HashSet();
        for (MuleModule module : this.moduleRepository.getModules()) {
            if (module.getPrivilegedArtifacts().contains(descriptor.getBundleDescriptor().getGroupId() + ":" + descriptor.getBundleDescriptor().getArtifactId())) {
                for (String packageName : module.getPrivilegedExportedPackages()) {
                    pluginsLookupPolicies.put(packageName, containerOnlyLookupStrategy);
                }
            }
            muleModulesExportedPackages.addAll(module.getExportedPackages());
        }
        HashMap<String, LookupStrategy> pluginLocalPolicies = new HashMap<String, LookupStrategy>();
        for (String localPackage : descriptor.getClassLoaderModel().getLocalPackages()) {
            if (baseLookupPolicy.getPackageLookupStrategy(localPackage) instanceof ContainerOnlyLookupStrategy || baseLookupPolicy.getPackageLookupStrategy(localPackage) instanceof ParentFirstLookupStrategy && muleModulesExportedPackages.contains(localPackage)) {
                LOGGER.warn("Plugin '" + descriptor.getName() + "' contains a local package '" + localPackage + "', but it will be ignored since it is already available from the container.");
                continue;
            }
            pluginLocalPolicies.put(localPackage, ChildOnlyLookupStrategy.CHILD_ONLY);
        }
        return baseLookupPolicy.extend(pluginsLookupPolicies).extend(pluginLocalPolicies, true);
    }

    private List<ArtifactPluginDescriptor> getPluginDescriptors(ArtifactPluginDescriptor descriptor, List<ArtifactPluginDescriptor> artifactPluginDescriptors) {
        return artifactPluginDescriptors.stream().filter(d -> this.isDependencyPlugin(descriptor.getClassLoaderModel().getDependencies(), (ArtifactPluginDescriptor)((Object)d))).collect(Collectors.toList());
    }

    private boolean isPrivilegedPluginDependency(ArtifactPluginDescriptor descriptor, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        if (dependencyPluginDescriptor.getClassLoaderModel().getPrivilegedExportedPackages().isEmpty()) {
            return false;
        }
        return dependencyPluginDescriptor.getClassLoaderModel().getPrivilegedArtifacts().stream().filter(a -> a.startsWith(descriptor.getBundleDescriptor().getGroupId() + ":" + descriptor.getBundleDescriptor().getArtifactId())).findFirst().isPresent();
    }

    private LookupStrategy getClassLoaderLookupStrategy(ArtifactPluginDescriptor descriptor, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        LookupStrategy lookupStrategy = this.isDependencyPlugin(descriptor.getClassLoaderModel().getDependencies(), dependencyPluginDescriptor) ? ParentFirstLookupStrategy.PARENT_FIRST : ChildOnlyLookupStrategy.CHILD_ONLY;
        return lookupStrategy;
    }

    private boolean isDependencyPlugin(Set<BundleDependency> dependencies, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        for (BundleDependency pluginDependency : dependencies) {
            if (!pluginDependency.getDescriptor().getArtifactId().equals(dependencyPluginDescriptor.getBundleDescriptor().getArtifactId()) || !pluginDependency.getDescriptor().getGroupId().equals(dependencyPluginDescriptor.getBundleDescriptor().getGroupId()) || !"mule-plugin".equals(pluginDependency.getDescriptor().getClassifier().orElse(null))) continue;
            return true;
        }
        return false;
    }
}

