/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactClassLoaderBuilder<T extends AbstractArtifactClassLoaderBuilder> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RegionPluginClassLoadersFactory pluginClassLoadersFactory;
    private final List<ArtifactPluginDescriptor> artifactPluginDescriptors = new LinkedList<ArtifactPluginDescriptor>();
    protected ArtifactDescriptor artifactDescriptor;

    public AbstractArtifactClassLoaderBuilder(RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        Preconditions.checkArgument((pluginClassLoadersFactory != null ? 1 : 0) != 0, (String)"pluginClassLoadersFactory cannot be null");
        this.pluginClassLoadersFactory = pluginClassLoadersFactory;
    }

    protected abstract ArtifactClassLoader getParentClassLoader();

    public T addArtifactPluginDescriptors(ArtifactPluginDescriptor ... artifactPluginDescriptors) {
        Preconditions.checkArgument((artifactPluginDescriptors != null ? 1 : 0) != 0, (String)"artifact plugin descriptors cannot be null");
        this.artifactPluginDescriptors.addAll(Arrays.asList(artifactPluginDescriptors));
        return (T)this;
    }

    public T setArtifactDescriptor(ArtifactDescriptor artifactDescriptor) {
        this.artifactDescriptor = artifactDescriptor;
        return (T)this;
    }

    public ArtifactClassLoader build() {
        Preconditions.checkState((this.artifactDescriptor != null ? 1 : 0) != 0, (String)"artifact descriptor cannot be null");
        ArtifactClassLoader parentClassLoader = this.getParentClassLoader();
        Preconditions.checkState((parentClassLoader != null ? 1 : 0) != 0, (String)"parent class loader cannot be null");
        String artifactId = this.getArtifactId(this.artifactDescriptor);
        ClassLoaderLookupPolicy parentLookupPolicy = this.getParentLookupPolicy(parentClassLoader);
        RegionClassLoader regionClassLoader = this.createRegionClassLoader(artifactId, this.artifactDescriptor, parentClassLoader.getClassLoader(), parentLookupPolicy);
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.createArtifactClassLoaderFilter(this.artifactDescriptor.getClassLoaderConfiguration(), parentLookupPolicy);
        Map appAdditionalLookupStrategy = artifactClassLoaderFilter.getExportedClassPackages().stream().collect(Collectors.toMap(UnaryOperator.identity(), p -> ParentFirstLookupStrategy.PARENT_FIRST));
        ArtifactClassLoader artifactClassLoader = this.createArtifactClassLoader(artifactId, regionClassLoader);
        regionClassLoader.addClassLoader(artifactClassLoader, artifactClassLoaderFilter);
        List<ArtifactClassLoader> artifactPluginClassLoaders = this.pluginClassLoadersFactory.createPluginClassLoaders((ArtifactClassLoader)regionClassLoader, this.artifactPluginDescriptors, regionClassLoader.getClassLoaderLookupPolicy().extend(appAdditionalLookupStrategy));
        int artifactPluginIndex = 0;
        for (ArtifactPluginDescriptor artifactPluginDescriptor : this.artifactPluginDescriptors) {
            ArtifactClassLoaderFilter classLoaderFilter = this.createPluginClassLoaderFilter(artifactPluginDescriptor, this.artifactDescriptor.getClassLoaderConfiguration().getExportedPackages(), parentLookupPolicy);
            regionClassLoader.addClassLoader(artifactPluginClassLoaders.get(artifactPluginIndex), classLoaderFilter);
            ++artifactPluginIndex;
        }
        return artifactClassLoader;
    }

    protected RegionClassLoader createRegionClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parentClassLoader, ClassLoaderLookupPolicy parentLookupPolicy) {
        return new RegionClassLoader(artifactId, artifactDescriptor, parentClassLoader, parentLookupPolicy);
    }

    protected ClassLoaderLookupPolicy getParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        return parentClassLoader.getClassLoaderLookupPolicy();
    }

    protected abstract ArtifactClassLoader createArtifactClassLoader(String var1, RegionClassLoader var2);

    private ArtifactClassLoaderFilter createArtifactClassLoaderFilter(ClassLoaderConfiguration classLoaderConfiguration, ClassLoaderLookupPolicy classLoaderLookupPolicy) {
        Set<String> artifactExportedPackages = this.sanitizeExportedPackages(classLoaderLookupPolicy, classLoaderConfiguration.getExportedPackages());
        return new DefaultArtifactClassLoaderFilter(artifactExportedPackages, classLoaderConfiguration.getExportedResources());
    }

    private ArtifactClassLoaderFilter createPluginClassLoaderFilter(ArtifactPluginDescriptor pluginDescriptor, Set<String> parentArtifactExportedPackages, ClassLoaderLookupPolicy classLoaderLookupPolicy) {
        Set<String> sanitizedArtifactExportedPackages = this.sanitizeExportedPackages(classLoaderLookupPolicy, pluginDescriptor.getClassLoaderConfiguration().getExportedPackages());
        Set replacedPackages = parentArtifactExportedPackages.stream().filter(p -> sanitizedArtifactExportedPackages.contains(p)).collect(Collectors.toSet());
        if (!replacedPackages.isEmpty()) {
            sanitizedArtifactExportedPackages.removeAll(replacedPackages);
            this.logger.warn("Exported packages from plugin '" + pluginDescriptor.getName() + "' are provided by the artifact owner: " + String.valueOf(replacedPackages));
        }
        return new DefaultArtifactClassLoaderFilter(sanitizedArtifactExportedPackages, pluginDescriptor.getClassLoaderConfiguration().getExportedResources());
    }

    private Set<String> sanitizeExportedPackages(ClassLoaderLookupPolicy classLoaderLookupPolicy, Set<String> artifactExportedPackages) {
        HashSet<String> sanitizedArtifactExportedPackages = new HashSet<String>(artifactExportedPackages);
        Set containerProvidedPackages = sanitizedArtifactExportedPackages.stream().filter(p -> {
            LookupStrategy lookupStrategy = classLoaderLookupPolicy.getPackageLookupStrategy(p);
            return !(lookupStrategy instanceof ChildFirstLookupStrategy);
        }).collect(Collectors.toSet());
        if (!containerProvidedPackages.isEmpty()) {
            sanitizedArtifactExportedPackages.removeAll(containerProvidedPackages);
            this.logger.warn("Exported packages from artifact '" + this.artifactDescriptor.getName() + "' are provided by parent class loader: " + String.valueOf(containerProvidedPackages));
        }
        return sanitizedArtifactExportedPackages;
    }

    protected abstract String getArtifactId(ArtifactDescriptor var1);
}

