/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.artifact.ArtifactConfigurationProcessor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactoryUtils;
import org.mule.runtime.module.license.api.LicenseValidator;

public abstract class AbstractDeployableArtifactFactory<D extends DeployableArtifactDescriptor, T extends DeployableArtifact<D>>
implements ArtifactFactory<D, T> {
    private final LicenseValidator licenseValidator;
    private final LockFactory runtimeLockFactory;
    private final MemoryManagementService memoryManagementService;
    private final ArtifactConfigurationProcessor artifactConfigurationProcessor;

    public AbstractDeployableArtifactFactory(LicenseValidator licenseValidator, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService, ArtifactConfigurationProcessor artifactConfigurationProcessor) {
        this.licenseValidator = licenseValidator;
        this.runtimeLockFactory = runtimeLockFactory;
        this.memoryManagementService = memoryManagementService;
        this.artifactConfigurationProcessor = artifactConfigurationProcessor;
    }

    @Override
    public T createArtifact(File artifactDir, Optional<Properties> properties) throws IOException {
        T artifact = this.doCreateArtifact(artifactDir, properties);
        ArtifactFactoryUtils.validateArtifactLicense(artifact.getArtifactClassLoader().getClassLoader(), artifact.getArtifactPlugins(), this.licenseValidator);
        return artifact;
    }

    protected abstract T doCreateArtifact(File var1, Optional<Properties> var2) throws IOException;

    public abstract DeployableArtifactDescriptor createArtifactDescriptor(File var1, Optional<Properties> var2);

    public LockFactory getRuntimeLockFactory() {
        return this.runtimeLockFactory;
    }

    public MemoryManagementService getMemoryManagementService() {
        return this.memoryManagementService;
    }

    public ArtifactConfigurationProcessor getArtifactConfigurationProcessor() {
        return this.artifactConfigurationProcessor;
    }
}

