/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.PropertiesBootstrapService;
import org.mule.runtime.core.api.config.bootstrap.PropertiesBootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.util.PropertiesUtils;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;

public class ArtifactBootstrapServiceDiscovererConfigurationBuilder
extends AbstractConfigurationBuilder {
    private final List<ArtifactPlugin> artifactPlugins;

    public ArtifactBootstrapServiceDiscovererConfigurationBuilder(List<ArtifactPlugin> artifactPlugins) {
        Preconditions.checkArgument((artifactPlugins != null ? 1 : 0) != 0, (String)"ArtifactPlugins cannot be null");
        this.artifactPlugins = artifactPlugins;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        PropertiesBootstrapServiceDiscoverer propertiesBootstrapServiceDiscoverer = new PropertiesBootstrapServiceDiscoverer(((Object)((Object)this)).getClass().getClassLoader());
        LinkedList<PropertiesBootstrapService> bootstrapServices = new LinkedList<PropertiesBootstrapService>();
        bootstrapServices.addAll(propertiesBootstrapServiceDiscoverer.discover());
        for (ArtifactPlugin artifactPlugin : this.artifactPlugins) {
            Enumeration resources = artifactPlugin.getArtifactClassLoader().findResources("META-INF/org/mule/runtime/core/config/registry-bootstrap.properties");
            while (resources.hasMoreElements()) {
                URL localResource = (URL)resources.nextElement();
                Properties properties = PropertiesUtils.loadProperties((URL)localResource);
                PropertiesBootstrapService pluginBootstrapService = new PropertiesBootstrapService(artifactPlugin.getArtifactClassLoader().getClassLoader(), properties);
                bootstrapServices.add(pluginBootstrapService);
            }
        }
        muleContext.setBootstrapServiceDiscoverer(() -> bootstrapServices);
    }
}

