/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.maven.AbstractMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedBundleDescriptorAttributes;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class MavenBundleDescriptorLoader
implements BundleDescriptorLoader {
    private static final String JAR = "jar";

    public String getId() {
        return "mule";
    }

    public BundleDescriptor load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        if (this.isHeavyPackage(artifactFile)) {
            File classLoaderModelDescriptor = this.getClassLoaderModelDescriptor(artifactFile);
            ClassLoaderModel packagerClassLoaderModel = ClassLoaderModelJsonSerializer.deserialize((File)classLoaderModelDescriptor);
            return new BundleDescriptor.Builder().setArtifactId(packagerClassLoaderModel.getArtifactCoordinates().getArtifactId()).setGroupId(packagerClassLoaderModel.getArtifactCoordinates().getGroupId()).setVersion(packagerClassLoaderModel.getArtifactCoordinates().getVersion()).setBaseVersion(packagerClassLoaderModel.getArtifactCoordinates().getVersion()).setType(packagerClassLoaderModel.getArtifactCoordinates().getType()).setClassifier(packagerClassLoaderModel.getArtifactCoordinates().getClassifier()).build();
        }
        if (attributes instanceof PluginExtendedBundleDescriptorAttributes) {
            return ((PluginExtendedBundleDescriptorAttributes)((Object)attributes)).getPluginBundleDescriptor();
        }
        return this.getBundleDescriptor(artifactFile, artifactType);
    }

    private BundleDescriptor getBundleDescriptor(File artifactFile, ArtifactType artifactType) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder();
        if (artifactType.equals((Object)ArtifactType.APP) || artifactType.equals((Object)ArtifactType.DOMAIN)) {
            Properties pomProperties = artifactFile.isDirectory() ? MavenUtils.getPomPropertiesFolder(artifactFile) : MavenUtils.getPomPropertiesFromJar(artifactFile);
            return builder.setGroupId(pomProperties.getProperty("groupId")).setArtifactId(pomProperties.getProperty("artifactId")).setVersion(pomProperties.getProperty("version")).setClassifier(artifactType.equals((Object)ArtifactType.APP) ? "mule-application" : "mule-domain").build();
        }
        Model model = artifactFile.isDirectory() ? MavenUtils.getPomModelFolder(artifactFile) : MavenUtils.getPomModelFromJar(artifactFile);
        return new BundleDescriptor.Builder().setArtifactId(model.getArtifactId()).setGroupId(model.getGroupId() != null ? model.getGroupId() : model.getParent().getGroupId()).setVersion(model.getVersion() != null ? model.getVersion() : model.getParent().getVersion()).setType(JAR).setClassifier(artifactType.equals((Object)ArtifactType.PLUGIN) ? "mule-plugin" : model.getPackaging()).build();
    }

    private boolean isHeavyPackage(File artifactFile) {
        return this.getClassLoaderModelDescriptor(artifactFile).exists();
    }

    protected File getClassLoaderModelDescriptor(File artifactFile) {
        if (artifactFile.isDirectory()) {
            return new File(artifactFile, AbstractMavenClassLoaderModelLoader.CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION);
        }
        return new File(artifactFile.getParent(), "classloader-model.json");
    }
}

