/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

public class DefaultClassLoaderManager
implements ArtifactClassLoaderManager,
ClassLoaderRepository {
    private final Map<String, ArtifactClassLoader> artifactClassLoaders = new ConcurrentHashMap<String, ArtifactClassLoader>();

    public void register(ArtifactClassLoader artifactClassLoader) {
        Objects.requireNonNull(artifactClassLoader, "artifactClassLoader cannot be null");
        this.artifactClassLoaders.put(artifactClassLoader.getArtifactId(), artifactClassLoader);
    }

    public ArtifactClassLoader unregister(String classLoaderId) {
        this.checkClassLoaderId(classLoaderId);
        return this.artifactClassLoaders.remove(classLoaderId);
    }

    public Optional<ClassLoader> find(String classLoaderId) {
        this.checkClassLoaderId(classLoaderId);
        ArtifactClassLoader artifactClassLoader = this.artifactClassLoaders.get(classLoaderId);
        return artifactClassLoader != null ? Optional.of(artifactClassLoader.getClassLoader()) : Optional.empty();
    }

    public Optional<String> getId(ClassLoader classLoader) {
        return this.artifactClassLoaders.values().stream().filter(artifactClassLoader -> artifactClassLoader.getClassLoader().equals(classLoader)).findFirst().map(ArtifactClassLoader::getArtifactId);
    }

    private void checkClassLoaderId(String classLoaderId) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)Objects.requireNonNull(classLoaderId)) ? 1 : 0) != 0, (String)"artifactId cannot be empty");
    }
}

