/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeArtifactExtensionManager
implements ExtensionManager,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeArtifactExtensionManager.class);
    private final ExtensionManager parentExtensionManager;
    private final ExtensionManager childExtensionManager;
    private final Set<ExtensionModel> extensionModels;

    public CompositeArtifactExtensionManager(ExtensionManager parentExtensionManager, ExtensionManager childExtensionManager) {
        Preconditions.checkArgument((parentExtensionManager != null ? 1 : 0) != 0, (String)"parentExtensionManager cannot be null");
        Preconditions.checkArgument((childExtensionManager != null ? 1 : 0) != 0, (String)"childExtensionManager cannot be null");
        this.parentExtensionManager = parentExtensionManager;
        this.childExtensionManager = childExtensionManager;
        this.extensionModels = new HashSet<ExtensionModel>();
        this.extensionModels.addAll(parentExtensionManager.getExtensions());
        this.extensionModels.addAll(childExtensionManager.getExtensions());
    }

    public void registerExtension(ExtensionModel extensionModel) {
        throw new UnsupportedOperationException("Composite extension manager cannot register extensions");
    }

    public Set<ExtensionModel> getExtensions() {
        return this.extensionModels;
    }

    public Optional<ExtensionModel> getExtension(String extensionName) {
        return this.extensionModels.stream().filter(extensionModel -> extensionModel.getName().equals(extensionName)).findFirst();
    }

    public ConfigurationInstance getConfiguration(String configurationProviderName, CoreEvent event) {
        return this.getConfigurationProvider(configurationProviderName).map(provider -> provider.get((Event)event)).orElseThrow(() -> new IllegalArgumentException(String.format("There is no registered configurationProvider under name '%s'", configurationProviderName)));
    }

    public Optional<ConfigurationInstance> getConfiguration(ExtensionModel extensionModel, ComponentModel componentModel, CoreEvent event) {
        Optional configuration = this.childExtensionManager.getConfiguration(extensionModel, componentModel, event);
        if (configuration.isPresent()) {
            return configuration;
        }
        Optional<ConfigurationProvider> provider = this.getConfigurationProvider(extensionModel, componentModel);
        if (provider.isPresent()) {
            return Optional.ofNullable(provider.get().get((Event)event));
        }
        throw new IllegalArgumentException(String.format("There is no registered configuration provider for extension '%s'", extensionModel.getName()));
    }

    public Optional<ConfigurationProvider> getConfigurationProvider(String configurationProviderName) {
        Optional configurationProvider = this.childExtensionManager.getConfigurationProvider(configurationProviderName);
        if (!configurationProvider.isPresent()) {
            configurationProvider = this.parentExtensionManager.getConfigurationProvider(configurationProviderName);
        }
        return configurationProvider;
    }

    public Optional<ConfigurationProvider> getConfigurationProvider(ExtensionModel extensionModel, ComponentModel componentModel) {
        Optional configurationModel = this.childExtensionManager.getConfigurationProvider(extensionModel, componentModel);
        if (!configurationModel.isPresent()) {
            configurationModel = this.parentExtensionManager.getConfigurationProvider(extensionModel, componentModel);
        }
        return configurationModel;
    }

    public void registerConfigurationProvider(ConfigurationProvider configurationProvider) {
        throw new UnsupportedOperationException("Composite extension manager cannot register extension providers");
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.childExtensionManager);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.childExtensionManager);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.childExtensionManager);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.childExtensionManager, (Logger)LOGGER);
    }

    public ExtensionManager getParentExtensionManager() {
        return this.parentExtensionManager;
    }

    public ExtensionManager getChildExtensionManager() {
        return this.childExtensionManager;
    }
}

