/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal.splash;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.internal.splash.PropertyChecker;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SplashScreen {
    public static Logger LOGGER = LoggerFactory.getLogger(SplashScreen.class);
    public static final int DEFAULT_MESSAGE_WIDTH = 80;
    public static final String RUNTIME_VERBOSE = "mule.runtime.verbose";
    public static final String CUSTOM_NAMES = "mule.splash.masked.properties";
    private static final List<String> CREDENTIAL_NAMES = Arrays.asList("key", "password", "pswd");
    private static final Set<String> CUSTOM_CREDENTIAL_NAMES = new HashSet<String>(Arrays.asList(System.getProperty("mule.splash.masked.properties", "").split(",")));
    public static final String CREDENTIAL_MASK = "*****";
    protected static PropertyChecker RUNTIME_VERBOSE_PROPERTY = new PropertyChecker("mule.runtime.verbose", Boolean.TRUE.toString());
    protected static final String VALUE_FORMAT = " - %s";
    private static final String KEY_VALUE_FORMAT = " - %s = %s";
    protected List<String> header = new ArrayList<String>();
    protected List<String> body = new ArrayList<String>();
    protected List<String> footer = new ArrayList<String>();

    public final void setHeader(MuleContext context) {
        this.header.clear();
        this.doHeader(context);
    }

    public final void addBody(String line) {
        this.doBody(line);
    }

    public final void setFooter(MuleContext context) {
        this.footer.clear();
        this.doFooter(context);
    }

    public static String miniSplash(String message) {
        return " + " + message;
    }

    protected void doHeader(MuleContext context) {
    }

    protected void doBody(String line) {
        this.body.add(line);
    }

    protected void doFooter(MuleContext context) {
    }

    protected void listItems(Collection<String> items, String description) {
        if (!items.isEmpty()) {
            this.doBody(description);
            for (String item : items) {
                this.doBody(String.format(VALUE_FORMAT, item));
            }
        }
    }

    private boolean isCredentialItem(String key) {
        if (CUSTOM_CREDENTIAL_NAMES.contains(key)) {
            return true;
        }
        for (String credentialName : CREDENTIAL_NAMES) {
            if (!key.toLowerCase().contains(credentialName)) continue;
            return true;
        }
        return false;
    }

    protected void listItems(Map<String, String> map, String description) {
        if (!map.isEmpty()) {
            this.doBody(description);
            for (String key : map.keySet()) {
                String value = this.isCredentialItem(key) ? CREDENTIAL_MASK : map.get(key);
                this.doBody(String.format(KEY_VALUE_FORMAT, key, value));
            }
        }
    }

    public String toString() {
        ArrayList<String> messages = new ArrayList<String>(this.header);
        messages.addAll(this.body);
        messages.addAll(this.footer);
        return SplashScreen.wrapInTextBox(messages, '*', 70);
    }

    private static String wrapInTextBox(List<String> messages, char c, int maxlength) {
        StringBuilder buf = new StringBuilder(messages.size() * maxlength);
        int trimLength = maxlength - (c == ' ' ? 2 : 4);
        messages = messages.stream().map(string -> string.split(System.lineSeparator())).flatMap(Arrays::stream).collect(Collectors.toList());
        for (int i = 0; i < messages.size(); ++i) {
            int size = messages.get(i).toString().length();
            if (size <= trimLength) continue;
            String temp = messages.get(i).toString();
            int k = i;
            messages.remove(i);
            while (temp.length() > 0) {
                int len = trimLength <= temp.length() ? trimLength : temp.length();
                String msg = temp.substring(0, len);
                int x = msg.indexOf(System.lineSeparator());
                if (x > -1) {
                    msg = msg.substring(0, x);
                    len = x + 1;
                } else {
                    x = msg.lastIndexOf(32);
                    if (x > -1 && len == trimLength) {
                        msg = msg.substring(0, x);
                        len = x + 1;
                    }
                }
                if (msg.startsWith(" ")) {
                    msg = msg.substring(1);
                }
                temp = temp.substring(len);
                messages.add(k, msg);
                ++k;
            }
        }
        buf.append(System.lineSeparator());
        if (c != ' ') {
            buf.append(StringUtils.repeat((char)c, (int)maxlength));
        }
        for (String message : messages) {
            int padding;
            buf.append(System.lineSeparator());
            if (c != ' ') {
                buf.append(c);
            }
            buf.append(" ");
            buf.append(message);
            String osEncoding = Charset.defaultCharset().name();
            try {
                padding = trimLength - message.toString().getBytes(osEncoding).length;
            }
            catch (UnsupportedEncodingException ueex) {
                throw new MuleRuntimeException(CoreMessages.failedToConvertStringUsingEncoding((String)osEncoding), (Throwable)ueex);
            }
            if (padding > 0) {
                buf.append(StringUtils.repeat((String)" ", (int)padding));
            }
            buf.append(' ');
            if (c == ' ') continue;
            buf.append(c);
        }
        buf.append(System.lineSeparator());
        if (c != ' ') {
            buf.append(StringUtils.repeat((char)c, (int)maxlength));
        }
        return buf.toString();
    }

    protected SplashScreen() {
    }
}

