/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.DefaultArtifactClassLoaderFilter;

public class ContainerClassLoaderFilterFactory {
    private static final String EMPTY_PACKAGE = "";
    private static final char RESOURCE_SEPARATOR = '/';

    public ClassLoaderFilter create(Set<String> bootPackages, List<MuleModule> muleModules) {
        Set<String> resources = this.getExportedResourcePaths(muleModules);
        Set<String> packages = this.getModuleExportedPackages(muleModules);
        DefaultArtifactClassLoaderFilter artifactClassLoaderFilter = new DefaultArtifactClassLoaderFilter(packages, resources);
        return new ContainerClassLoaderFilter((ClassLoaderFilter)artifactClassLoaderFilter, bootPackages);
    }

    private Set<String> getExportedResourcePaths(List<MuleModule> muleModules) {
        HashSet<String> resources = new HashSet<String>();
        for (MuleModule muleModule : muleModules) {
            resources.addAll(muleModule.getExportedPaths());
        }
        return resources;
    }

    private Set<String> getModuleExportedPackages(List<MuleModule> muleModules) {
        HashSet<String> packages = new HashSet<String>();
        for (MuleModule muleModule : muleModules) {
            packages.addAll(muleModule.getExportedPackages());
        }
        return packages;
    }

    public static class ContainerClassLoaderFilter
    implements ClassLoaderFilter {
        public static final String CLASS_PACKAGE_SPLIT_REGEX = "\\.";
        public static final String RESOURCE_PACKAGE_SPLIT_REGEX = "/";
        private final ClassLoaderFilter moduleClassLoaderFilter;
        private final Set<String> bootPackages;

        public ContainerClassLoaderFilter(ClassLoaderFilter moduleClassLoaderFilter, Set<String> bootPackages) {
            this.moduleClassLoaderFilter = moduleClassLoaderFilter;
            this.bootPackages = bootPackages;
        }

        public boolean exportsClass(String name) {
            boolean exported = this.moduleClassLoaderFilter.exportsClass(name);
            if (!exported) {
                exported = this.isExportedBooPackage(name, CLASS_PACKAGE_SPLIT_REGEX);
            }
            return exported;
        }

        public boolean exportsResource(String name) {
            String resourceFolder;
            boolean exported = this.moduleClassLoaderFilter.exportsResource(name);
            if (!exported && !(exported = this.moduleClassLoaderFilter.exportsResource(resourceFolder = this.getResourceFolder(name)))) {
                exported = this.isExportedBooPackage(name, RESOURCE_PACKAGE_SPLIT_REGEX);
            }
            return exported;
        }

        private String getResourceFolder(String resourceName) {
            String resourceFolder = ContainerClassLoaderFilterFactory.EMPTY_PACKAGE;
            if (resourceName.length() > 0) {
                resourceFolder = resourceName.charAt(0) == '/' ? resourceName.substring(1) : resourceName;
                resourceFolder = resourceFolder.lastIndexOf(47) < 0 ? ContainerClassLoaderFilterFactory.EMPTY_PACKAGE : resourceFolder.substring(0, resourceFolder.lastIndexOf(47));
            }
            return resourceFolder;
        }

        private boolean isExportedBooPackage(String name, String splitRegex) {
            boolean exported = false;
            String[] splitName = name.split(splitRegex);
            String[] packages = Arrays.copyOf(splitName, splitName.length - 1);
            String candidatePackage = ContainerClassLoaderFilterFactory.EMPTY_PACKAGE;
            for (String currentPackage : packages) {
                if (candidatePackage.length() != 0) {
                    candidatePackage = candidatePackage + ".";
                }
                if (!this.bootPackages.contains(candidatePackage = candidatePackage + currentPackage)) continue;
                exported = true;
                break;
            }
            return exported;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

