/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

@NoInstantiate
public final class MuleArtifactUrlConnection
extends URLConnection {
    static final String SEPARATOR = "!/";
    private static final List<String> SUPPORTED_PROTOCOLS = Arrays.asList("file");
    private ZipFile artifactZip;
    private List<String> files;

    public MuleArtifactUrlConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.parseSpecs();
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        ArrayDeque<String> queue = new ArrayDeque<String>(this.files);
        String filename = (String)queue.pop();
        ZipEntry entry = this.artifactZip.getEntry(filename);
        if (entry == null) {
            throw new MalformedURLException(String.format("File '%s' is missing in '%s' artifact", filename, this.artifactZip.getName()));
        }
        InputStream is = this.artifactZip.getInputStream(entry);
        if (!queue.isEmpty()) {
            is = this.getInputStream(is, queue);
        }
        return is;
    }

    private void parseSpecs() throws MalformedURLException {
        URL muleArtifactLocation;
        String spec = this.url.getFile();
        int separator = this.seekFirstSeparator(spec);
        if (!SUPPORTED_PROTOCOLS.contains((muleArtifactLocation = new URL(spec.substring(0, separator++))).getProtocol())) {
            throw new MalformedURLException(String.format("Supported protocols for '%s' are '%s', but received '%s' (full URL received '%s')", "muleartifact", String.join((CharSequence)",", SUPPORTED_PROTOCOLS), muleArtifactLocation.getProtocol(), this.url.toString()));
        }
        try {
            this.artifactZip = new ZipFile(FileUtils.toFile((URL)muleArtifactLocation));
        }
        catch (IOException e) {
            throw new MalformedURLException(String.format("There was a problem opening a zip for '%s'", muleArtifactLocation));
        }
        this.files = this.getFiles(spec.substring(++separator));
    }

    private int seekFirstSeparator(String spec) throws MalformedURLException {
        int separator = spec.indexOf(SEPARATOR);
        if (separator == -1) {
            throw new MalformedURLException(String.format("No separator '%s' found in url spec '%s'", SEPARATOR, spec));
        }
        return separator;
    }

    private InputStream getInputStream(InputStream currentStream, Deque<String> files) throws IOException {
        ZipEntry entry;
        if (files.isEmpty()) {
            return currentStream;
        }
        String expectedFile = files.pop();
        ZipInputStream zipInputStream = new ZipInputStream(currentStream);
        while ((entry = zipInputStream.getNextEntry()) != null) {
            if (!entry.getName().equals(expectedFile)) continue;
            return this.getInputStream(zipInputStream, files);
        }
        throw new MalformedURLException(String.format("Can't find the %s file in %s", expectedFile, this.artifactZip.getName()));
    }

    private List<String> getFiles(String files) {
        if (files.isEmpty()) {
            throw new IllegalArgumentException(String.format("There's no file to process after the first '%s' (full URL received '%s')", SEPARATOR, this.url.toString()));
        }
        String[] resources = files.split(SEPARATOR);
        if (resources.length == 2 && !this.isCompressed(resources[0])) {
            return Arrays.asList(resources[0].concat("/").concat(resources[1]));
        }
        return Arrays.stream(resources).map(resource -> {
            try {
                return URLDecoder.decode(resource, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to decode %s with unsupported encoding", resource)));
            }
        }).collect(Collectors.toList());
    }

    private boolean isCompressed(String resource) {
        return StringUtils.endsWithIgnoreCase((CharSequence)resource, (CharSequence)".zip") || StringUtils.endsWithIgnoreCase((CharSequence)resource, (CharSequence)".jar");
    }
}

