/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyResourceReleaser
implements ResourceReleaser {
    private final ClassLoader classLoader;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyResourceReleaser.class);
    private static final String GROOVY_CLASS_INFO = "org.codehaus.groovy.reflection.ClassInfo";
    private static final String GROOVY_INVOKER_HELPER = "org.codehaus.groovy.runtime.InvokerHelper";

    public GroovyResourceReleaser(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void release() {
        this.unregisterAllClassesFromInvokerHelper();
    }

    private void unregisterAllClassesFromInvokerHelper() {
        try {
            Class<?> classInfoClass = this.classLoader.loadClass(GROOVY_CLASS_INFO);
            Method getAllClassInfoMethod = classInfoClass.getMethod("getAllClassInfo", new Class[0]);
            Method getTheClassMethod = classInfoClass.getMethod("getTheClass", new Class[0]);
            Class<?> invokerHelperClass = this.classLoader.loadClass(GROOVY_INVOKER_HELPER);
            Method removeClassMethod = invokerHelperClass.getMethod("removeClass", Class.class);
            Object classInfos = getAllClassInfoMethod.invoke(null, new Object[0]);
            if (classInfos instanceof Collection) {
                this.unregisterClassesFromInvokerHelper(removeClassMethod, getTheClassMethod, (Collection)classInfos);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Error trying to remove the Groovy's InvokerHelper classes", (Throwable)e);
        }
    }

    private void unregisterClassesFromInvokerHelper(Method removeClassMethod, Method getTheClassMethod, Collection<?> classes) {
        for (Object classInfo : classes) {
            Object clazz = null;
            try {
                clazz = getTheClassMethod.invoke(classInfo, new Object[0]);
                removeClassMethod.invoke(null, clazz);
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                String className = clazz instanceof Class ? ((Class)clazz).getName() : "Unknown";
                LOGGER.warn("Could not remove the {} class from the Groovy's InvokerHelper", (Object)className, (Object)e);
            }
        }
    }
}

