/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;

public final class BundleDependency {
    private BundleDescriptor descriptor;
    private BundleScope scope;
    private URI bundleUri;
    private List<BundleDependency> additionalDependencies;
    private List<BundleDependency> transitiveDependencies;
    private Set<String> packages;
    private Set<String> resources;

    private BundleDependency() {
    }

    public BundleScope getScope() {
        return this.scope != null ? this.scope : BundleScope.COMPILE;
    }

    public BundleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public URI getBundleUri() {
        return this.bundleUri;
    }

    @Deprecated
    public Set<BundleDependency> getAdditionalDependencies() {
        return new LinkedHashSet<BundleDependency>(this.additionalDependencies);
    }

    public List<BundleDependency> getAdditionalDependenciesList() {
        return this.additionalDependencies;
    }

    @Deprecated
    public Set<BundleDependency> getTransitiveDependencies() {
        return new LinkedHashSet<BundleDependency>(this.transitiveDependencies);
    }

    public List<BundleDependency> getTransitiveDependenciesList() {
        return this.transitiveDependencies;
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public String toString() {
        return "BundleDependency{descriptor=" + this.descriptor + ", scope=" + (Object)((Object)this.scope) + ", bundleUri=" + this.bundleUri + ", additionalDependencies=" + this.additionalDependencies + ", packages=" + this.packages + ", resources=" + this.resources + '}';
    }

    public static class Builder {
        private static final String BUNDLE_DESCRIPTOR = "bundle descriptor";
        private static final String REQUIRED_FIELD_IS_NULL = "bundle cannot be created with null %s";
        private final BundleDependency bundleDependency = new BundleDependency();

        public Builder() {
        }

        public Builder(BundleDependency template) {
            this.bundleDependency.bundleUri = template.bundleUri;
            this.bundleDependency.descriptor = template.descriptor;
            this.bundleDependency.scope = template.scope;
            this.bundleDependency.additionalDependencies = template.additionalDependencies;
            this.bundleDependency.transitiveDependencies = template.transitiveDependencies;
            this.bundleDependency.packages = template.packages;
            this.bundleDependency.resources = template.resources;
        }

        public Builder setDescriptor(BundleDescriptor descriptor) {
            this.validateIsNotNull(descriptor, BUNDLE_DESCRIPTOR);
            this.bundleDependency.descriptor = descriptor;
            return this;
        }

        public Builder setScope(BundleScope scope) {
            Preconditions.checkState((scope != null ? 1 : 0) != 0, (Object)"scope cannot be null");
            this.bundleDependency.scope = scope;
            return this;
        }

        public Builder setBundleUri(URI bundleUri) {
            this.bundleDependency.bundleUri = bundleUri;
            return this;
        }

        @Deprecated
        public Builder setAdditionalDependencies(Set<BundleDependency> additionalDependencies) {
            this.bundleDependency.additionalDependencies = new ArrayList<BundleDependency>(additionalDependencies);
            return this;
        }

        public Builder setAdditionalDependencies(List<BundleDependency> additionalDependencies) {
            this.bundleDependency.additionalDependencies = additionalDependencies;
            return this;
        }

        @Deprecated
        public Builder setTransitiveDependencies(Set<BundleDependency> transitiveDependencies) {
            this.bundleDependency.transitiveDependencies = new ArrayList<BundleDependency>(transitiveDependencies);
            return this;
        }

        public Builder setTransitiveDependencies(List<BundleDependency> transitiveDependencies) {
            this.bundleDependency.transitiveDependencies = transitiveDependencies;
            return this;
        }

        public Builder setPackages(Set<String> packages) {
            this.bundleDependency.packages = packages;
            return this;
        }

        public Builder setResources(Set<String> resources) {
            this.bundleDependency.resources = resources;
            return this;
        }

        public BundleDependency build() {
            this.validateIsNotNull(this.bundleDependency.descriptor, BUNDLE_DESCRIPTOR);
            return this.bundleDependency;
        }

        private String getNullFieldMessage(String field) {
            return String.format(REQUIRED_FIELD_IS_NULL, field);
        }

        private void validateIsNotNull(Object value, String fieldId) {
            Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)this.getNullFieldMessage(fieldId));
        }
    }
}

