/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQResourceReleaser
implements ResourceReleaser {
    public static final String ACTIVEMQ_DRIVER_TIMER_THREAD_CLASS_NAME = "TimerThread";
    public static final String ACTIVEMQ_DRIVER_TIMER_THREAD_NAME = "ActiveMQ InactivityMonitor ReadCheckTimer";
    public static final String COMPOSITE_CLASS_LOADER_CLASS_NAME = "CompositeClassLoader";
    private final ClassLoader classLoader;
    private static final Logger logger = LoggerFactory.getLogger(ActiveMQResourceReleaser.class);

    public ActiveMQResourceReleaser(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void release() {
        this.disposeActiveMQThreads();
    }

    private void disposeActiveMQThreads() {
        try {
            Thread[] threads = new Thread[Thread.activeCount()];
            try {
                Thread.enumerate(threads);
            }
            catch (SecurityException t) {
                logger.debug("An error occurred trying to obtain available Threads. Thread cleanup will be skipped.", (Throwable)t);
                return;
            }
            for (Thread thread : threads) {
                if (!this.isActiveMQInactivityMonitorTimerThread(this.classLoader, thread)) continue;
                this.clearReferencesStopTimerThread(thread);
                thread.interrupt();
                thread.join();
            }
        }
        catch (Exception e) {
            logger.error("An exception occurred while attempting to dispose of activeMQ timer threads: {}", (Object)e.getMessage());
        }
    }

    private boolean isActiveMQInactivityMonitorTimerThread(ClassLoader classLoader, Thread thread) {
        if (!(classLoader instanceof ArtifactClassLoader)) {
            return false;
        }
        String artifactId = ((ArtifactClassLoader)((Object)classLoader)).getArtifactId();
        return thread.getClass().getSimpleName().equals(ACTIVEMQ_DRIVER_TIMER_THREAD_CLASS_NAME) && thread.getName().equals(ACTIVEMQ_DRIVER_TIMER_THREAD_NAME) && (this.isThreadLoadedByDisposedApplication(artifactId, thread.getContextClassLoader()) || this.isThreadLoadedByDisposedDomain(artifactId, thread.getContextClassLoader()));
    }

    private boolean isThreadLoadedByDisposedDomain(String undeployedArtifactId, ClassLoader threadContextClassLoader) {
        try {
            Class<?> threadContextClassLoaderClass = threadContextClassLoader.getClass();
            if (!threadContextClassLoaderClass.getSimpleName().equals(COMPOSITE_CLASS_LOADER_CLASS_NAME)) {
                return false;
            }
            Method getDelegateClassLoadersMethod = threadContextClassLoaderClass.getMethod("getDelegates", new Class[0]);
            List classLoaderList = (List)getDelegateClassLoadersMethod.invoke((Object)threadContextClassLoader, new Object[0]);
            for (ClassLoader classLoaderDelegate : classLoaderList) {
                ArtifactClassLoader artifactClassLoader;
                if (!(classLoaderDelegate instanceof ArtifactClassLoader) || !(artifactClassLoader = (ArtifactClassLoader)((Object)classLoaderDelegate)).getArtifactId().contains(undeployedArtifactId)) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("Exception occurred while attempting to compare {} and {} artifactId.", (Object)threadContextClassLoader, (Object)threadContextClassLoader.getClass().getClassLoader());
        }
        return false;
    }

    private boolean isThreadLoadedByDisposedApplication(String undeployedArtifactId, ClassLoader threadContextClassLoader) {
        try {
            if (!(threadContextClassLoader instanceof MuleArtifactClassLoader)) {
                return false;
            }
            String threadClassLoaderArtifactId = ((MuleArtifactClassLoader)threadContextClassLoader).getArtifactId();
            return threadClassLoaderArtifactId != null && threadClassLoaderArtifactId.equals(undeployedArtifactId);
        }
        catch (Exception e) {
            logger.warn("Exception occurred while attempting to compare {} and {} artifact id.", (Object)threadContextClassLoader, (Object)threadContextClassLoader.getClass().getClassLoader());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesStopTimerThread(Thread thread) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        try {
            Field newTasksMayBeScheduledField = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
            newTasksMayBeScheduledField.setAccessible(true);
            Field queueField = thread.getClass().getDeclaredField("queue");
            queueField.setAccessible(true);
            Object queue = queueField.get(thread);
            Method clearMethod = queue.getClass().getDeclaredMethod("clear", new Class[0]);
            clearMethod.setAccessible(true);
            Object object = queue;
            synchronized (object) {
                newTasksMayBeScheduledField.setBoolean(thread, false);
                clearMethod.invoke(queue, new Object[0]);
                queue.notifyAll();
            }
        }
        catch (NoSuchFieldException noSuchFieldEx) {
            logger.warn("Unable to clear timer references using 'clear' method. Attempting to use 'cancel' method.");
            Method cancelMethod = thread.getClass().getDeclaredMethod("cancel", new Class[0]);
            cancelMethod.setAccessible(true);
            cancelMethod.invoke((Object)thread, new Object[0]);
        }
    }
}

