/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;

@NoInstantiate
public final class DefaultArtifactClassLoaderFilter
implements ArtifactClassLoaderFilter {
    public static final ArtifactClassLoaderFilter NULL_CLASSLOADER_FILTER = new DefaultArtifactClassLoaderFilter(Collections.emptySet(), Collections.emptySet());
    private static final char PACKAGE_SEPARATOR = '.';
    private static final String EMPTY_PACKAGE = "";
    private static final char RESOURCE_SEPARATOR = '/';
    private final Set<String> exportedClassPackages;
    private final Set<String> exportedResources;

    public DefaultArtifactClassLoaderFilter(Set<String> exportedClassPackages, Set<String> exportedResources) {
        Preconditions.checkArgument((exportedClassPackages != null ? 1 : 0) != 0, (String)"Exported class packages cannot be null");
        Preconditions.checkArgument((exportedResources != null ? 1 : 0) != 0, (String)"Exported resource cannot be null");
        this.exportedClassPackages = Collections.unmodifiableSet(this.sanitizeClassPackageS(exportedClassPackages));
        this.exportedResources = Collections.unmodifiableSet(this.sanitizeExportedResources(exportedResources));
    }

    private Set<String> sanitizeExportedResources(Set<String> exportedResources) {
        return exportedResources.stream().map(this::sanitizeResourceName).collect(Collectors.toSet());
    }

    private Set<String> sanitizeClassPackageS(Set<String> exportedClassPackages) {
        return exportedClassPackages.stream().map(this::sanitizePackageName).collect(Collectors.toSet());
    }

    private String sanitizePackageName(String exportedClassPackage) {
        exportedClassPackage = (exportedClassPackage = exportedClassPackage.trim()).endsWith(".") ? exportedClassPackage.substring(0, exportedClassPackage.length() - 1) : exportedClassPackage;
        return exportedClassPackage;
    }

    @Override
    public boolean exportsClass(String className) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)className) ? 1 : 0) != 0, (String)"Class name cannot be empty");
        String packageName = this.getPackageName(className);
        return this.exportsPackage(packageName);
    }

    @Override
    public boolean exportsPackage(String name) {
        return name != null ? this.exportedClassPackages.contains(name) : false;
    }

    @Override
    public boolean exportsResource(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Resource name cannot be null");
        String sanitizeResourceName = this.sanitizeResourceName(name);
        return this.exportedResources.contains(sanitizeResourceName);
    }

    @Override
    public Set<String> getExportedClassPackages() {
        return this.exportedClassPackages;
    }

    @Override
    public Set<String> getExportedResources() {
        return this.exportedResources;
    }

    private String sanitizeResourceName(String resourceName) {
        String sanitizedResource = EMPTY_PACKAGE;
        if (resourceName.length() > 0) {
            String string = sanitizedResource = resourceName.charAt(0) == '/' ? resourceName.substring(1) : resourceName;
            if (sanitizedResource.length() > 0) {
                sanitizedResource = sanitizedResource.charAt(sanitizedResource.length() - 1) == '/' ? sanitizedResource.substring(0, sanitizedResource.length() - 1) : sanitizedResource;
            }
        }
        return sanitizedResource;
    }

    private String getPackageName(String className) {
        return className.lastIndexOf(46) < 0 ? EMPTY_PACKAGE : className.substring(0, className.lastIndexOf(46));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

