/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.serializer;

import java.util.Objects;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.core.internal.serialization.JavaExternalSerializerProtocol;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.serializer.protocol.CustomJavaSerializationProtocol;

@NoInstantiate
public final class ArtifactObjectSerializer
implements ObjectSerializer {
    private volatile JavaExternalSerializerProtocol javaExternalSerializerProtocol;
    private volatile CustomJavaSerializationProtocol javaInternalSerializerProtocol;

    public ArtifactObjectSerializer(ClassLoaderRepository classLoaderRepository, ClassLoader executionClassLoader) {
        Objects.requireNonNull(classLoaderRepository, "ClassLoaderRepository cannot be null");
        Objects.requireNonNull(executionClassLoader, "executionClassLoader cannot be null");
        this.javaExternalSerializerProtocol = new JavaExternalSerializerProtocol(executionClassLoader);
        this.javaInternalSerializerProtocol = new CustomJavaSerializationProtocol(classLoaderRepository, executionClassLoader);
    }

    public SerializationProtocol getInternalProtocol() {
        return this.javaInternalSerializerProtocol;
    }

    public SerializationProtocol getExternalProtocol() {
        return this.javaExternalSerializerProtocol;
    }
}

