/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

public class ArtifactClassLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoaderRepository classLoaderRepository;

    public ArtifactClassLoaderObjectInputStream(ClassLoaderRepository classLoaderRepository, InputStream input) throws IOException {
        super(input);
        this.classLoaderRepository = classLoaderRepository;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        int val = this.readInt();
        if (val == -1) {
            return super.resolveClass(desc);
        }
        byte[] bytes = new byte[val];
        this.readFully(bytes);
        String classLoaderId = new String(bytes);
        ClassLoader classLoader = this.classLoaderRepository.find(classLoaderId).orElseThrow(() -> new IOException("Artifact class loader not found: " + classLoaderId));
        return Class.forName(desc.getName(), false, classLoader);
    }
}

