/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;

public class BundleDependency {
    private BundleDescriptor descriptor;
    private BundleScope scope;
    private URI bundleUri;

    private BundleDependency() {
    }

    public BundleScope getScope() {
        return this.scope;
    }

    public BundleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public URI getBundleUri() {
        return this.bundleUri;
    }

    public String toString() {
        return "BundleDependency{descriptor=" + this.descriptor + ", scope=" + (Object)((Object)this.scope) + ", bundleUri=" + this.bundleUri + '}';
    }

    public static class Builder {
        private static final String BUNDLE_DESCRIPTOR = "bundle descriptor";
        private static final String REQUIRED_FIELD_IS_NULL = "bundle cannot be created with null %s";
        private BundleDependency bundleDependency = new BundleDependency();

        public Builder setDescriptor(BundleDescriptor descriptor) {
            this.validateIsNotNull(descriptor, BUNDLE_DESCRIPTOR);
            this.bundleDependency.descriptor = descriptor;
            return this;
        }

        public Builder setScope(BundleScope scope) {
            Preconditions.checkState((scope != null ? 1 : 0) != 0, (Object)"scope cannot be null");
            this.bundleDependency.scope = scope;
            return this;
        }

        public Builder setBundleUri(URI bundleUri) {
            this.bundleDependency.bundleUri = bundleUri;
            return this;
        }

        public BundleDependency build() {
            this.validateIsNotNull(this.bundleDependency.descriptor, BUNDLE_DESCRIPTOR);
            return this.bundleDependency;
        }

        private String getNullFieldMessage(String field) {
            return String.format(REQUIRED_FIELD_IS_NULL, field);
        }

        private void validateIsNotNull(Object value, String fieldId) {
            Preconditions.checkState((value != null ? 1 : 0) != 0, (Object)this.getNullFieldMessage(fieldId));
        }
    }
}

