/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.service.config;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;

public class ContainerServiceConfigurator
implements ServiceConfigurator {
    private final List<Service> services;

    public ContainerServiceConfigurator(List<Service> services) {
        Preconditions.checkArgument((services != null ? 1 : 0) != 0, (String)"services cannot be null");
        this.services = new ArrayList<Service>(services);
    }

    public void configure(CustomizationService customizationService) {
        this.services.forEach(service -> {
            Object name = service.getName();
            String contract = service.getContractName();
            if (!StringUtils.isEmpty((String)contract)) {
                name = (String)name + " - " + contract;
            }
            customizationService.registerCustomServiceImpl((String)name, service);
        });
    }
}

