/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.classloader.model.ClassLoaderModelAssembler;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.Plugin;

public class DeployableClassLoaderModelAssembler
extends ClassLoaderModelAssembler {
    private final Map<BundleDescriptor, List<BundleDependency>> additionalPluginDependencies;

    public DeployableClassLoaderModelAssembler(DeployableProjectModel model) {
        super(new ArtifactCoordinates(model.getDescriptor().getGroupId(), model.getDescriptor().getArtifactId(), model.getDescriptor().getVersion(), model.getDescriptor().getType(), (String)model.getDescriptor().getClassifier().orElse(null)), model.getDependencies(), model.getSharedLibraries(), model.getPackages(), model.getResources());
        this.additionalPluginDependencies = model.getAdditionalPluginDependencies();
    }

    @Override
    public ClassLoaderModel createClassLoaderModel() {
        AppClassLoaderModel deployableModel = new AppClassLoaderModel("1.2.0", this.getArtifactCoordinates());
        this.assembleClassLoaderModel((ClassLoaderModel)deployableModel);
        deployableModel.setAdditionalPluginDependencies(this.additionalPluginDependencies.entrySet().stream().map(pluginEntry -> {
            Plugin plugin = new Plugin();
            plugin.setArtifactId(((BundleDescriptor)pluginEntry.getKey()).getArtifactId());
            plugin.setGroupId(((BundleDescriptor)pluginEntry.getKey()).getGroupId());
            plugin.setAdditionalDependencies(this.toArtifacts((List)pluginEntry.getValue()));
            return plugin;
        }).collect(Collectors.toList()));
        return deployableModel;
    }
}

