/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.deployable;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.Plugin;

public class DeployableClassLoaderConfigurationBuilder
extends ClassLoaderConfiguration.ClassLoaderConfigurationBuilder {
    private final ClassLoaderModel packagerClassLoaderModel;
    private final File artifactFolder;

    public DeployableClassLoaderConfigurationBuilder(ClassLoaderModel packagerClassLoaderModel, File artifactFolder) {
        if (!(packagerClassLoaderModel instanceof AppClassLoaderModel)) {
            throw new IllegalArgumentException("Class loader model must be an 'AppClassLoaderModel' for deployables.");
        }
        this.packagerClassLoaderModel = packagerClassLoaderModel;
        this.artifactFolder = artifactFolder;
    }

    public ClassLoaderConfiguration build() {
        this.exportSharedLibrariesResourcesAndPackages();
        this.processAdditionalPluginLibraries();
        return super.build();
    }

    private void exportSharedLibrariesResourcesAndPackages() {
        this.packagerClassLoaderModel.getDependencies().stream().filter(Artifact::isShared).forEach(sharedDep -> {
            this.exportingPackages(sharedDep.getPackages() == null ? Collections.emptySet() : Sets.newHashSet((Object[])sharedDep.getPackages()));
            this.exportingResources(sharedDep.getResources() == null ? Collections.emptySet() : Sets.newHashSet((Object[])sharedDep.getResources()));
        });
    }

    private void processAdditionalPluginLibraries() {
        AppClassLoaderModel appClassLoaderModel = (AppClassLoaderModel)this.packagerClassLoaderModel;
        appClassLoaderModel.getAdditionalPluginDependencies().ifPresent(additionalDeps -> additionalDeps.forEach(this::updateDependency));
    }

    private void updateDependency(Plugin plugin) {
        this.dependencies.stream().filter(dep -> this.areSameDependency(plugin, (BundleDependency)dep)).findFirst().ifPresent(pluginDependency -> this.replaceBundleDependency((BundleDependency)pluginDependency, this.createExtendedBundleDependency((BundleDependency)pluginDependency, plugin.getAdditionalDependencies().stream().map(this::toBundleDependency).collect(Collectors.toList()))));
    }

    private BundleDependency createExtendedBundleDependency(BundleDependency original, List<BundleDependency> additionalPluginDependencies) {
        return new BundleDependency.Builder(original).setAdditionalDependencies(additionalPluginDependencies).build();
    }

    private void replaceBundleDependency(BundleDependency original, BundleDependency modified) {
        this.dependencies.remove(original);
        this.dependencies.add(modified);
    }

    private boolean areSameDependency(Plugin plugin, BundleDependency dependency) {
        return StringUtils.equals((CharSequence)dependency.getDescriptor().getGroupId(), (CharSequence)plugin.getGroupId()) && StringUtils.equals((CharSequence)dependency.getDescriptor().getArtifactId(), (CharSequence)plugin.getArtifactId());
    }

    private BundleDependency toBundleDependency(Artifact artifact) {
        BundleDependency.Builder builder = new BundleDependency.Builder();
        if (artifact.getArtifactCoordinates().getScope() != null) {
            builder.setScope(BundleScope.valueOf((String)artifact.getArtifactCoordinates().getScope().toUpperCase()));
        }
        BundleDependency.Builder bundleDependencyBuilder = builder.setBundleUri(artifact.getUri().isAbsolute() ? artifact.getUri() : new File(this.artifactFolder, artifact.getUri().toString()).toURI()).setDescriptor(new BundleDescriptor.Builder().setArtifactId(artifact.getArtifactCoordinates().getArtifactId()).setGroupId(artifact.getArtifactCoordinates().getGroupId()).setVersion(artifact.getArtifactCoordinates().getVersion()).setClassifier(artifact.getArtifactCoordinates().getClassifier()).setType(artifact.getArtifactCoordinates().getType()).build());
        bundleDependencyBuilder.setPackages(artifact.getPackages() == null ? Collections.emptySet() : Sets.newHashSet((Object[])artifact.getPackages()));
        bundleDependencyBuilder.setResources(artifact.getResources() == null ? Collections.emptySet() : Sets.newHashSet((Object[])artifact.getResources()));
        return bundleDependencyBuilder.build();
    }
}

