/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.core.internal.util.jar.JarLoadingUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;

public interface PluginModelResolver {
    public static PluginModelResolver pluginModelResolver() {
        return bundleDependency -> {
            Optional jsonDescriptorContentOptional;
            File pluginJarFile = new File(bundleDependency.getBundleUri());
            String mulePluginJsonPathInsideJarFile = "META-INF/mule-artifact/mule-artifact.json";
            try {
                jsonDescriptorContentOptional = JarLoadingUtils.loadFileContentFrom((File)pluginJarFile, (String)mulePluginJsonPathInsideJarFile);
            }
            catch (IOException e) {
                throw new ArtifactDescriptorCreateException((Throwable)e);
            }
            return jsonDescriptorContentOptional.map(jsonDescriptorContent -> (MulePluginModel)new MulePluginModelJsonSerializer().deserialize(new String((byte[])jsonDescriptorContent, StandardCharsets.UTF_8))).orElseThrow(() -> new ArtifactDescriptorCreateException(String.format("The plugin descriptor '%s' on plugin file '%s' is not present", mulePluginJsonPathInsideJarFile, pluginJarFile)));
        };
    }

    public MulePluginModel resolve(BundleDependency var1) throws ArtifactDescriptorCreateException;
}

