/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.api.plugin;

import java.util.List;
import java.util.Map;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginResolutionError;

public class DuplicateExportedPackageException
extends PluginResolutionError {
    public DuplicateExportedPackageException(Map<String, List<String>> pluginsPerPackage) {
        super(DuplicateExportedPackageException.buildPackageDuplicationErrorMessage(pluginsPerPackage));
    }

    private static String buildPackageDuplicationErrorMessage(Map<String, List<String>> exportedPackages) {
        StringBuilder errorMessageBuilder = new StringBuilder("There are multiple artifacts exporting the same package:");
        for (String packageName : exportedPackages.keySet()) {
            List<String> exportedOn = exportedPackages.get(packageName);
            if (exportedOn.size() <= 1) continue;
            errorMessageBuilder.append("\nPackage ").append(packageName).append(" is exported on artifacts: ");
            boolean firstPlugin = true;
            for (String plugin : exportedOn) {
                if (firstPlugin) {
                    firstPlugin = false;
                } else {
                    errorMessageBuilder.append(", ");
                }
                errorMessageBuilder.append(plugin);
            }
        }
        return errorMessageBuilder.toString();
    }
}

