/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl.meter.error;

import java.util.Collections;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.metrics.api.error.ErrorIdProvider;
import org.mule.runtime.metrics.api.error.ErrorMetrics;
import org.mule.runtime.metrics.api.instrument.LongCounter;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.impl.util.StackHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorMetrics
implements ErrorMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultErrorMetrics.class);
    private final LongCounter totalErrorsCounter;
    private final ErrorIdProvider errorIdProvider;

    public DefaultErrorMetrics(Meter errorMetricsMeter) {
        this.totalErrorsCounter = this.buildNewErrorCounter(errorMetricsMeter);
        this.errorIdProvider = this.getDefaultErrorIdProvider();
    }

    public DefaultErrorMetrics(Meter errorMetricsMeter, ErrorIdProvider errorIdProvider) {
        this.totalErrorsCounter = this.buildNewErrorCounter(errorMetricsMeter);
        this.errorIdProvider = errorIdProvider;
    }

    public void measure(Error error) {
        try {
            this.measure(error.getCause());
        }
        catch (Throwable e) {
            LOGGER.error("Failed to measure an error. This will only affect the error metrics data.", e);
        }
    }

    public void measure(Throwable error) {
        try {
            this.totalErrorsCounter.add(1L, Collections.singletonMap("error-id", this.errorIdProvider.getErrorId(error)));
        }
        catch (Throwable e) {
            LOGGER.error("Failed to measure an error. This will only affect the error metrics data.", e);
        }
    }

    private LongCounter buildNewErrorCounter(Meter errorMetricsMeter) {
        return (LongCounter)errorMetricsMeter.counterBuilder("error-count").withDescription("Mule runtime error count").build();
    }

    private ErrorIdProvider getDefaultErrorIdProvider() {
        return new ErrorIdProvider(){
            private final StackHasher stackHasher = new StackHasher();

            public String getErrorId(Error error) {
                return this.rootHash(error.getCause());
            }

            public String getErrorId(Throwable error) {
                return this.rootHash(error);
            }

            private String rootHash(Throwable error) {
                return this.stackHasher.hexHash(ExceptionHelper.getRootException((Throwable)error));
            }
        };
    }
}

