/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.impl.capturer;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricExporter;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CapturingMeterExporterWrapper
implements MetricExporter {
    private final Set<InMemoryMetricExporter> meterSniffers = ConcurrentHashMap.newKeySet();

    public CompletableResultCode export(Collection<MetricData> metrics) {
        this.meterSniffers.forEach(sniffer -> sniffer.export(metrics));
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return null;
    }

    public CompletableResultCode shutdown() {
        return null;
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public InMemoryMetricExporter getExportedMeterSniffer() {
        InMemoryMetricExporter meterSniffer = InMemoryMetricExporter.create();
        this.meterSniffers.add(meterSniffer);
        return meterSniffer;
    }

    public void dispose(InMemoryMetricExporter meterSniffer) {
        this.meterSniffers.remove(meterSniffer);
    }
}

