/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.SerializationContext;

public class DefaultObjectTypeReferenceHandler
implements ObjectTypeReferenceHandler {
    private final SerializationContext serializationContext;

    public DefaultObjectTypeReferenceHandler(SerializationContext serializationContext) {
        this.serializationContext = serializationContext;
    }

    @Override
    public Optional<TypeBuilder> readReference(String typeReference) {
        if (typeReference.startsWith("@ref:")) {
            return this.serializationContext.getRegisteredObjectType(typeReference.replace("@ref:", "")).map(type -> () -> type);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldWriteReference(ObjectType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).isPresent();
    }

    @Override
    public Optional<String> writeReference(ObjectType type, JsonWriter writer) {
        String serializationId = this.serializationContext.registerObjectType(type);
        try {
            writer.name("type").value("@ref:" + serializationId);
        }
        catch (IOException e) {
            throw new MetadataSerializingException("Unexpected error occurred writing type reference", e);
        }
        return Optional.of(serializationId);
    }
}

