/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.AccessibilityAnnotation;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.persistence.type.adapter.EnumTypeAnnotationTypeAdapter;
import org.mule.metadata.persistence.type.adapter.OnlyOneFieldTypeAdapterFactory;
import org.mule.metadata.persistence.type.adapter.OptionalTypeAdapterFactory;

public final class TypeAnnotationSerializer {
    private static final String ERROR_DESERIALIZING_TYPE_ANNOTATION = "Error deserializing TypeAnnotation '%s'.";
    private final HashBiMap<String, Class<? extends TypeAnnotation>> stringClassHashMap = HashBiMap.create();
    private final Gson gson;

    public TypeAnnotationSerializer(Map<String, Class<? extends TypeAnnotation>> stingClassMapping, Collection<Object> additionalFeatures) {
        this.stringClassHashMap.putAll(stingClassMapping);
        GsonBuilder builder = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new OptionalTypeAdapterFactory()).registerTypeAdapter(EnumAnnotation.class, (Object)new EnumTypeAnnotationTypeAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new OnlyOneFieldTypeAdapterFactory(AccessibilityAnnotation.class, LabelAnnotation.class, DefaultValueAnnotation.class, TypeIdAnnotation.class, RegexPatternAnnotation.class, ExampleAnnotation.class, DefaultValueAnnotation.class, RegexPatternAnnotation.class));
        additionalFeatures.forEach(feature -> {
            if (feature instanceof TypeAdapterFactory) {
                builder.registerTypeAdapterFactory((TypeAdapterFactory)feature);
            }
        });
        this.gson = builder.create();
    }

    public <T extends TypeAnnotation> Optional<T> deserialize(String typeAnnotationName, String json) {
        Optional<Object> optionalSerialization = Optional.empty();
        try {
            Optional<Class<? extends TypeAnnotation>> annotationClass = this.getAnnotationClass(typeAnnotationName);
            if (annotationClass.isPresent()) {
                optionalSerialization = Optional.of((TypeAnnotation)this.gson.getAdapter(annotationClass.get()).fromJson(json));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(ERROR_DESERIALIZING_TYPE_ANNOTATION, typeAnnotationName), e);
        }
        return optionalSerialization;
    }

    <T extends TypeAnnotation> void serialize(JsonWriter jsonWriter, T typeAnnotation) {
        this.gson.toJson(typeAnnotation, new TypeToken<T>(){}.getType(), jsonWriter);
    }

    private Optional<Class<? extends TypeAnnotation>> getAnnotationClass(String annotationName) {
        Optional<Class<Object>> optionalClass;
        Map<String, Class<? extends TypeAnnotation>> nameClassMapping = this.getNameClassMapping();
        if (nameClassMapping.containsKey(annotationName)) {
            optionalClass = Optional.of(nameClassMapping.get(annotationName));
        } else {
            try {
                optionalClass = Optional.of(Class.forName(annotationName));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(ERROR_DESERIALIZING_TYPE_ANNOTATION, annotationName), e);
            }
        }
        return optionalClass;
    }

    Map<String, Class<? extends TypeAnnotation>> getNameClassMapping() {
        return this.stringClassHashMap;
    }

    Map<Class<? extends TypeAnnotation>, String> getClassNameMapping() {
        return this.stringClassHashMap.inverse();
    }
}

