/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.everit.json.schema.Schema;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.utils.SchemaHelper;

public class JsonTypeLoader
implements TypeLoader {
    public static MetadataFormat JSON = MetadataFormat.JSON;
    private JsonSchemaLoader jsonSchemaLoader;

    public JsonTypeLoader(File schemaFile) {
        this.jsonSchemaLoader = new JsonSchemaFileLoader(schemaFile);
    }

    public JsonTypeLoader(String schemaData) {
        this(schemaData, null);
    }

    public JsonTypeLoader(String schemaData, URI baseURI) {
        this.jsonSchemaLoader = new JsonSchemaStringLoader(schemaData, baseURI);
    }

    private JsonSchemaLoader getJsonSchemaLoader() {
        return this.jsonSchemaLoader;
    }

    public Optional<MetadataType> load(String identifier) {
        return this.load(identifier, null);
    }

    public Optional<MetadataType> load(String identifier, String typeAlias) {
        Schema jsonSchema = this.getJsonSchemaLoader().loadSchema();
        TypeBuilder<?> typeBuilder = new HandlerManager().handle(jsonSchema, new ParsingContext());
        MetadataTypeUtils.addTypeAlias(typeBuilder, (String)typeAlias);
        return Optional.of(typeBuilder.build());
    }

    private static class JsonSchemaFileLoader
    implements JsonSchemaLoader {
        private File schemaFile;

        public JsonSchemaFileLoader(File schemaFile) {
            this.schemaFile = schemaFile;
        }

        @Override
        public Schema loadSchema() {
            Schema schema;
            FileInputStream inputStream = new FileInputStream(this.schemaFile);
            try {
                JSONObject rawSchema = new JSONObject(new JSONTokener((InputStream)inputStream));
                schema = SchemaHelper.generateSchema(rawSchema, this.schemaFile.toURI());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ((InputStream)inputStream).close();
            return schema;
        }
    }

    private static interface JsonSchemaLoader {
        public Schema loadSchema();
    }

    private static class JsonSchemaStringLoader
    implements JsonSchemaLoader {
        private final URI baseURI;
        private String schemaData;

        public JsonSchemaStringLoader(String schemaData, URI baseURI) {
            this.schemaData = schemaData;
            this.baseURI = baseURI;
        }

        @Override
        public Schema loadSchema() {
            JSONObject rawSchema = new JSONObject(new JSONTokener(this.schemaData));
            return SchemaHelper.generateSchema(rawSchema, this.baseURI);
        }
    }
}

