/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.ObjectFieldHandler;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.metadata.ast.internal.DefaultObjectFieldHandler;
import org.mule.metadata.ast.internal.TypeMirrorLoaderVisitor;
import org.mule.metadata.ast.internal.handler.ArrayTypeHandler;
import org.mule.metadata.ast.internal.handler.BinaryTypeHandler;
import org.mule.metadata.ast.internal.handler.BooleanTypeHandler;
import org.mule.metadata.ast.internal.handler.DateTypeHandler;
import org.mule.metadata.ast.internal.handler.EnumTypeHandler;
import org.mule.metadata.ast.internal.handler.MapTypeHandler;
import org.mule.metadata.ast.internal.handler.NumberTypeHandler;
import org.mule.metadata.ast.internal.handler.StringTypeHandler;

public final class ASTTypeLoader
implements TypeLoader {
    private ProcessingEnvironment processingEnvironment;
    private final ObjectFieldHandler objectFieldHandler;
    private List<TypeHandler> handlers;

    public ASTTypeLoader(ProcessingEnvironment processingEnvironment) {
        this(processingEnvironment, Collections.emptyList(), new DefaultObjectFieldHandler(processingEnvironment));
    }

    public ASTTypeLoader(ProcessingEnvironment processingEnvironment, List<TypeHandler> handlers, ObjectFieldHandler objectFieldHandler) {
        MetadataTypeUtils.checkArgument((handlers != null ? 1 : 0) != 0, (String)"Handlers can't be null");
        MetadataTypeUtils.checkArgument((objectFieldHandler != null ? 1 : 0) != 0, (String)"ObjectFieldHandler can't be null");
        this.processingEnvironment = processingEnvironment;
        this.objectFieldHandler = objectFieldHandler;
        this.handlers = new ArrayList<TypeHandler>();
        this.handlers.add(new StringTypeHandler(processingEnvironment));
        this.handlers.add(new BinaryTypeHandler(processingEnvironment));
        this.handlers.add(new NumberTypeHandler(processingEnvironment));
        this.handlers.add(new ArrayTypeHandler(processingEnvironment));
        this.handlers.add(new BooleanTypeHandler(processingEnvironment));
        this.handlers.add(new DateTypeHandler(processingEnvironment));
        this.handlers.add(new MapTypeHandler(processingEnvironment));
        this.handlers.add(new EnumTypeHandler(processingEnvironment));
        this.handlers.addAll(handlers);
    }

    public Optional<MetadataType> load(TypeMirror typeMirror) {
        TypeBuilder accept = (TypeBuilder)typeMirror.accept(new TypeMirrorLoaderVisitor(this.processingEnvironment, this.handlers, this.objectFieldHandler), new IntrospectionContext());
        return accept != null ? Optional.of(accept.build()) : Optional.empty();
    }

    public Optional<MetadataType> load(String typeIdentifier) {
        throw new UnsupportedOperationException("This method is not supported, please use #load(TypeMirror)");
    }
}

